package zio.aws.licensemanagerusersubscriptions.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ActiveDirectoryIdentityProvider(
    directoryId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ActiveDirectoryIdentityProvider = {
    import ActiveDirectoryIdentityProvider.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ActiveDirectoryIdentityProvider
      .builder()
      .optionallyWith(directoryId.map(value => value: java.lang.String))(
        _.directoryId
      )
      .build()
  }
  def asReadOnly
      : zio.aws.licensemanagerusersubscriptions.model.ActiveDirectoryIdentityProvider.ReadOnly =
    zio.aws.licensemanagerusersubscriptions.model.ActiveDirectoryIdentityProvider
      .wrap(buildAwsValue())
}
object ActiveDirectoryIdentityProvider {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ActiveDirectoryIdentityProvider
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.licensemanagerusersubscriptions.model.ActiveDirectoryIdentityProvider =
      zio.aws.licensemanagerusersubscriptions.model
        .ActiveDirectoryIdentityProvider(directoryId.map(value => value))
    def directoryId: Optional[String]
    def getDirectoryId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("directoryId", directoryId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ActiveDirectoryIdentityProvider
  ) extends zio.aws.licensemanagerusersubscriptions.model.ActiveDirectoryIdentityProvider.ReadOnly {
    override val directoryId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.directoryId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ActiveDirectoryIdentityProvider
  ): zio.aws.licensemanagerusersubscriptions.model.ActiveDirectoryIdentityProvider.ReadOnly =
    new Wrapper(impl)
}
