package zio.aws.licensemanagerusersubscriptions.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateIdentityProviderSettingsRequest(
    identityProvider: zio.aws.licensemanagerusersubscriptions.model.IdentityProvider,
    product: String,
    updateSettings: zio.aws.licensemanagerusersubscriptions.model.UpdateSettings
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanagerusersubscriptions.model.UpdateIdentityProviderSettingsRequest = {
    import UpdateIdentityProviderSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanagerusersubscriptions.model.UpdateIdentityProviderSettingsRequest
      .builder()
      .identityProvider(identityProvider.buildAwsValue())
      .product(product: java.lang.String)
      .updateSettings(updateSettings.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.licensemanagerusersubscriptions.model.UpdateIdentityProviderSettingsRequest.ReadOnly =
    zio.aws.licensemanagerusersubscriptions.model.UpdateIdentityProviderSettingsRequest
      .wrap(buildAwsValue())
}
object UpdateIdentityProviderSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanagerusersubscriptions.model.UpdateIdentityProviderSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.licensemanagerusersubscriptions.model.UpdateIdentityProviderSettingsRequest =
      zio.aws.licensemanagerusersubscriptions.model
        .UpdateIdentityProviderSettingsRequest(
          identityProvider.asEditable,
          product,
          updateSettings.asEditable
        )
    def identityProvider
        : zio.aws.licensemanagerusersubscriptions.model.IdentityProvider.ReadOnly
    def product: String
    def updateSettings
        : zio.aws.licensemanagerusersubscriptions.model.UpdateSettings.ReadOnly
    def getIdentityProvider: ZIO[
      Any,
      Nothing,
      zio.aws.licensemanagerusersubscriptions.model.IdentityProvider.ReadOnly
    ] = ZIO.succeed(identityProvider)
    def getProduct: ZIO[Any, Nothing, String] = ZIO.succeed(product)
    def getUpdateSettings: ZIO[
      Any,
      Nothing,
      zio.aws.licensemanagerusersubscriptions.model.UpdateSettings.ReadOnly
    ] = ZIO.succeed(updateSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.licensemanagerusersubscriptions.model.UpdateIdentityProviderSettingsRequest
  ) extends zio.aws.licensemanagerusersubscriptions.model.UpdateIdentityProviderSettingsRequest.ReadOnly {
    override val identityProvider
        : zio.aws.licensemanagerusersubscriptions.model.IdentityProvider.ReadOnly =
      zio.aws.licensemanagerusersubscriptions.model.IdentityProvider
        .wrap(impl.identityProvider())
    override val product: String = impl.product(): String
    override val updateSettings
        : zio.aws.licensemanagerusersubscriptions.model.UpdateSettings.ReadOnly =
      zio.aws.licensemanagerusersubscriptions.model.UpdateSettings
        .wrap(impl.updateSettings())
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanagerusersubscriptions.model.UpdateIdentityProviderSettingsRequest
  ): zio.aws.licensemanagerusersubscriptions.model.UpdateIdentityProviderSettingsRequest.ReadOnly =
    new Wrapper(impl)
}
