package zio.aws.licensemanagerusersubscriptions.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class IdentityProvider(
    activeDirectoryIdentityProvider: Optional[
      zio.aws.licensemanagerusersubscriptions.model.ActiveDirectoryIdentityProvider
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanagerusersubscriptions.model.IdentityProvider = {
    import IdentityProvider.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanagerusersubscriptions.model.IdentityProvider
      .builder()
      .optionallyWith(
        activeDirectoryIdentityProvider.map(value => value.buildAwsValue())
      )(_.activeDirectoryIdentityProvider)
      .build()
  }
  def asReadOnly
      : zio.aws.licensemanagerusersubscriptions.model.IdentityProvider.ReadOnly =
    zio.aws.licensemanagerusersubscriptions.model.IdentityProvider
      .wrap(buildAwsValue())
}
object IdentityProvider {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanagerusersubscriptions.model.IdentityProvider
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.licensemanagerusersubscriptions.model.IdentityProvider =
      zio.aws.licensemanagerusersubscriptions.model.IdentityProvider(
        activeDirectoryIdentityProvider.map(value => value.asEditable)
      )
    def activeDirectoryIdentityProvider: Optional[
      zio.aws.licensemanagerusersubscriptions.model.ActiveDirectoryIdentityProvider.ReadOnly
    ]
    def getActiveDirectoryIdentityProvider: ZIO[
      Any,
      AwsError,
      zio.aws.licensemanagerusersubscriptions.model.ActiveDirectoryIdentityProvider.ReadOnly
    ] = AwsError.unwrapOptionField(
      "activeDirectoryIdentityProvider",
      activeDirectoryIdentityProvider
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.licensemanagerusersubscriptions.model.IdentityProvider
  ) extends zio.aws.licensemanagerusersubscriptions.model.IdentityProvider.ReadOnly {
    override val activeDirectoryIdentityProvider: Optional[
      zio.aws.licensemanagerusersubscriptions.model.ActiveDirectoryIdentityProvider.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.activeDirectoryIdentityProvider())
      .map(value =>
        zio.aws.licensemanagerusersubscriptions.model.ActiveDirectoryIdentityProvider
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanagerusersubscriptions.model.IdentityProvider
  ): zio.aws.licensemanagerusersubscriptions.model.IdentityProvider.ReadOnly =
    new Wrapper(impl)
}
