package zio.aws.licensemanagerusersubscriptions.model
import zio.aws.licensemanagerusersubscriptions.model.primitives.BoxInteger
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListIdentityProvidersRequest(
    maxResults: Optional[BoxInteger] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListIdentityProvidersRequest = {
    import ListIdentityProvidersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListIdentityProvidersRequest
      .builder()
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.licensemanagerusersubscriptions.model.ListIdentityProvidersRequest.ReadOnly =
    zio.aws.licensemanagerusersubscriptions.model.ListIdentityProvidersRequest
      .wrap(buildAwsValue())
}
object ListIdentityProvidersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListIdentityProvidersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.licensemanagerusersubscriptions.model.ListIdentityProvidersRequest =
      zio.aws.licensemanagerusersubscriptions.model
        .ListIdentityProvidersRequest(
          maxResults.map(value => value),
          nextToken.map(value => value)
        )
    def maxResults: Optional[BoxInteger]
    def nextToken: Optional[String]
    def getMaxResults: ZIO[Any, AwsError, BoxInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListIdentityProvidersRequest
  ) extends zio.aws.licensemanagerusersubscriptions.model.ListIdentityProvidersRequest.ReadOnly {
    override val maxResults: Optional[BoxInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: BoxInteger)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListIdentityProvidersRequest
  ): zio.aws.licensemanagerusersubscriptions.model.ListIdentityProvidersRequest.ReadOnly =
    new Wrapper(impl)
}
