package zio.aws.licensemanagerusersubscriptions.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.licensemanagerusersubscriptions.model.primitives.{
  Subnet,
  SecurityGroup
}
import scala.jdk.CollectionConverters.*
final case class Settings(
    securityGroupId: SecurityGroup,
    subnets: Iterable[Subnet]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanagerusersubscriptions.model.Settings = {
    import Settings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanagerusersubscriptions.model.Settings
      .builder()
      .securityGroupId(SecurityGroup.unwrap(securityGroupId): java.lang.String)
      .subnets(subnets.map { item =>
        Subnet.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.licensemanagerusersubscriptions.model.Settings.ReadOnly =
    zio.aws.licensemanagerusersubscriptions.model.Settings.wrap(buildAwsValue())
}
object Settings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanagerusersubscriptions.model.Settings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.licensemanagerusersubscriptions.model.Settings =
      zio.aws.licensemanagerusersubscriptions.model
        .Settings(securityGroupId, subnets)
    def securityGroupId: SecurityGroup
    def subnets: List[Subnet]
    def getSecurityGroupId: ZIO[Any, Nothing, SecurityGroup] =
      ZIO.succeed(securityGroupId)
    def getSubnets: ZIO[Any, Nothing, List[Subnet]] = ZIO.succeed(subnets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.licensemanagerusersubscriptions.model.Settings
  ) extends zio.aws.licensemanagerusersubscriptions.model.Settings.ReadOnly {
    override val securityGroupId: SecurityGroup =
      zio.aws.licensemanagerusersubscriptions.model.primitives
        .SecurityGroup(impl.securityGroupId())
    override val subnets: List[Subnet] = impl
      .subnets()
      .asScala
      .map { item =>
        zio.aws.licensemanagerusersubscriptions.model.primitives.Subnet(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanagerusersubscriptions.model.Settings
  ): zio.aws.licensemanagerusersubscriptions.model.Settings.ReadOnly =
    new Wrapper(impl)
}
