package zio.aws.licensemanagerusersubscriptions.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AssociateUserRequest(
    domain: Optional[String] = Optional.Absent,
    identityProvider: zio.aws.licensemanagerusersubscriptions.model.IdentityProvider,
    instanceId: String,
    username: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanagerusersubscriptions.model.AssociateUserRequest = {
    import AssociateUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanagerusersubscriptions.model.AssociateUserRequest
      .builder()
      .optionallyWith(domain.map(value => value: java.lang.String))(_.domain)
      .identityProvider(identityProvider.buildAwsValue())
      .instanceId(instanceId: java.lang.String)
      .username(username: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.licensemanagerusersubscriptions.model.AssociateUserRequest.ReadOnly =
    zio.aws.licensemanagerusersubscriptions.model.AssociateUserRequest
      .wrap(buildAwsValue())
}
object AssociateUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanagerusersubscriptions.model.AssociateUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.licensemanagerusersubscriptions.model.AssociateUserRequest =
      zio.aws.licensemanagerusersubscriptions.model.AssociateUserRequest(
        domain.map(value => value),
        identityProvider.asEditable,
        instanceId,
        username
      )
    def domain: Optional[String]
    def identityProvider
        : zio.aws.licensemanagerusersubscriptions.model.IdentityProvider.ReadOnly
    def instanceId: String
    def username: String
    def getDomain: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("domain", domain)
    def getIdentityProvider: ZIO[
      Any,
      Nothing,
      zio.aws.licensemanagerusersubscriptions.model.IdentityProvider.ReadOnly
    ] = ZIO.succeed(identityProvider)
    def getInstanceId: ZIO[Any, Nothing, String] = ZIO.succeed(instanceId)
    def getUsername: ZIO[Any, Nothing, String] = ZIO.succeed(username)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.licensemanagerusersubscriptions.model.AssociateUserRequest
  ) extends zio.aws.licensemanagerusersubscriptions.model.AssociateUserRequest.ReadOnly {
    override val domain: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.domain())
      .map(value => value: String)
    override val identityProvider
        : zio.aws.licensemanagerusersubscriptions.model.IdentityProvider.ReadOnly =
      zio.aws.licensemanagerusersubscriptions.model.IdentityProvider
        .wrap(impl.identityProvider())
    override val instanceId: String = impl.instanceId(): String
    override val username: String = impl.username(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanagerusersubscriptions.model.AssociateUserRequest
  ): zio.aws.licensemanagerusersubscriptions.model.AssociateUserRequest.ReadOnly =
    new Wrapper(impl)
}
