package zio.aws.licensemanagerusersubscriptions.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ProductUserSummary(
    domain: Optional[String] = Optional.Absent,
    identityProvider: zio.aws.licensemanagerusersubscriptions.model.IdentityProvider,
    product: String,
    status: String,
    statusMessage: Optional[String] = Optional.Absent,
    subscriptionEndDate: Optional[String] = Optional.Absent,
    subscriptionStartDate: Optional[String] = Optional.Absent,
    username: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ProductUserSummary = {
    import ProductUserSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ProductUserSummary
      .builder()
      .optionallyWith(domain.map(value => value: java.lang.String))(_.domain)
      .identityProvider(identityProvider.buildAwsValue())
      .product(product: java.lang.String)
      .status(status: java.lang.String)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(
        subscriptionEndDate.map(value => value: java.lang.String)
      )(_.subscriptionEndDate)
      .optionallyWith(
        subscriptionStartDate.map(value => value: java.lang.String)
      )(_.subscriptionStartDate)
      .username(username: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.licensemanagerusersubscriptions.model.ProductUserSummary.ReadOnly =
    zio.aws.licensemanagerusersubscriptions.model.ProductUserSummary
      .wrap(buildAwsValue())
}
object ProductUserSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ProductUserSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.licensemanagerusersubscriptions.model.ProductUserSummary =
      zio.aws.licensemanagerusersubscriptions.model.ProductUserSummary(
        domain.map(value => value),
        identityProvider.asEditable,
        product,
        status,
        statusMessage.map(value => value),
        subscriptionEndDate.map(value => value),
        subscriptionStartDate.map(value => value),
        username
      )
    def domain: Optional[String]
    def identityProvider
        : zio.aws.licensemanagerusersubscriptions.model.IdentityProvider.ReadOnly
    def product: String
    def status: String
    def statusMessage: Optional[String]
    def subscriptionEndDate: Optional[String]
    def subscriptionStartDate: Optional[String]
    def username: String
    def getDomain: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("domain", domain)
    def getIdentityProvider: ZIO[
      Any,
      Nothing,
      zio.aws.licensemanagerusersubscriptions.model.IdentityProvider.ReadOnly
    ] = ZIO.succeed(identityProvider)
    def getProduct: ZIO[Any, Nothing, String] = ZIO.succeed(product)
    def getStatus: ZIO[Any, Nothing, String] = ZIO.succeed(status)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getSubscriptionEndDate: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subscriptionEndDate", subscriptionEndDate)
    def getSubscriptionStartDate: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subscriptionStartDate", subscriptionStartDate)
    def getUsername: ZIO[Any, Nothing, String] = ZIO.succeed(username)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ProductUserSummary
  ) extends zio.aws.licensemanagerusersubscriptions.model.ProductUserSummary.ReadOnly {
    override val domain: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.domain())
      .map(value => value: String)
    override val identityProvider
        : zio.aws.licensemanagerusersubscriptions.model.IdentityProvider.ReadOnly =
      zio.aws.licensemanagerusersubscriptions.model.IdentityProvider
        .wrap(impl.identityProvider())
    override val product: String = impl.product(): String
    override val status: String = impl.status(): String
    override val statusMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => value: String)
    override val subscriptionEndDate: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.subscriptionEndDate())
      .map(value => value: String)
    override val subscriptionStartDate: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.subscriptionStartDate())
      .map(value => value: String)
    override val username: String = impl.username(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ProductUserSummary
  ): zio.aws.licensemanagerusersubscriptions.model.ProductUserSummary.ReadOnly =
    new Wrapper(impl)
}
