package zio.aws.licensemanagerusersubscriptions.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class IdentityProviderSummary(
    failureMessage: Optional[String] = Optional.Absent,
    identityProvider: zio.aws.licensemanagerusersubscriptions.model.IdentityProvider,
    product: String,
    status: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanagerusersubscriptions.model.IdentityProviderSummary = {
    import IdentityProviderSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanagerusersubscriptions.model.IdentityProviderSummary
      .builder()
      .optionallyWith(failureMessage.map(value => value: java.lang.String))(
        _.failureMessage
      )
      .identityProvider(identityProvider.buildAwsValue())
      .product(product: java.lang.String)
      .status(status: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.licensemanagerusersubscriptions.model.IdentityProviderSummary.ReadOnly =
    zio.aws.licensemanagerusersubscriptions.model.IdentityProviderSummary
      .wrap(buildAwsValue())
}
object IdentityProviderSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanagerusersubscriptions.model.IdentityProviderSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.licensemanagerusersubscriptions.model.IdentityProviderSummary =
      zio.aws.licensemanagerusersubscriptions.model.IdentityProviderSummary(
        failureMessage.map(value => value),
        identityProvider.asEditable,
        product,
        status
      )
    def failureMessage: Optional[String]
    def identityProvider
        : zio.aws.licensemanagerusersubscriptions.model.IdentityProvider.ReadOnly
    def product: String
    def status: String
    def getFailureMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("failureMessage", failureMessage)
    def getIdentityProvider: ZIO[
      Any,
      Nothing,
      zio.aws.licensemanagerusersubscriptions.model.IdentityProvider.ReadOnly
    ] = ZIO.succeed(identityProvider)
    def getProduct: ZIO[Any, Nothing, String] = ZIO.succeed(product)
    def getStatus: ZIO[Any, Nothing, String] = ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.licensemanagerusersubscriptions.model.IdentityProviderSummary
  ) extends zio.aws.licensemanagerusersubscriptions.model.IdentityProviderSummary.ReadOnly {
    override val failureMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.failureMessage())
      .map(value => value: String)
    override val identityProvider
        : zio.aws.licensemanagerusersubscriptions.model.IdentityProvider.ReadOnly =
      zio.aws.licensemanagerusersubscriptions.model.IdentityProvider
        .wrap(impl.identityProvider())
    override val product: String = impl.product(): String
    override val status: String = impl.status(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanagerusersubscriptions.model.IdentityProviderSummary
  ): zio.aws.licensemanagerusersubscriptions.model.IdentityProviderSummary.ReadOnly =
    new Wrapper(impl)
}
