package zio.aws.licensemanagerusersubscriptions.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StopProductSubscriptionRequest(
    domain: Optional[String] = Optional.Absent,
    identityProvider: zio.aws.licensemanagerusersubscriptions.model.IdentityProvider,
    product: String,
    username: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanagerusersubscriptions.model.StopProductSubscriptionRequest = {
    import StopProductSubscriptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanagerusersubscriptions.model.StopProductSubscriptionRequest
      .builder()
      .optionallyWith(domain.map(value => value: java.lang.String))(_.domain)
      .identityProvider(identityProvider.buildAwsValue())
      .product(product: java.lang.String)
      .username(username: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.licensemanagerusersubscriptions.model.StopProductSubscriptionRequest.ReadOnly =
    zio.aws.licensemanagerusersubscriptions.model.StopProductSubscriptionRequest
      .wrap(buildAwsValue())
}
object StopProductSubscriptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanagerusersubscriptions.model.StopProductSubscriptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.licensemanagerusersubscriptions.model.StopProductSubscriptionRequest =
      zio.aws.licensemanagerusersubscriptions.model
        .StopProductSubscriptionRequest(
          domain.map(value => value),
          identityProvider.asEditable,
          product,
          username
        )
    def domain: Optional[String]
    def identityProvider
        : zio.aws.licensemanagerusersubscriptions.model.IdentityProvider.ReadOnly
    def product: String
    def username: String
    def getDomain: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("domain", domain)
    def getIdentityProvider: ZIO[
      Any,
      Nothing,
      zio.aws.licensemanagerusersubscriptions.model.IdentityProvider.ReadOnly
    ] = ZIO.succeed(identityProvider)
    def getProduct: ZIO[Any, Nothing, String] = ZIO.succeed(product)
    def getUsername: ZIO[Any, Nothing, String] = ZIO.succeed(username)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.licensemanagerusersubscriptions.model.StopProductSubscriptionRequest
  ) extends zio.aws.licensemanagerusersubscriptions.model.StopProductSubscriptionRequest.ReadOnly {
    override val domain: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.domain())
      .map(value => value: String)
    override val identityProvider
        : zio.aws.licensemanagerusersubscriptions.model.IdentityProvider.ReadOnly =
      zio.aws.licensemanagerusersubscriptions.model.IdentityProvider
        .wrap(impl.identityProvider())
    override val product: String = impl.product(): String
    override val username: String = impl.username(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanagerusersubscriptions.model.StopProductSubscriptionRequest
  ): zio.aws.licensemanagerusersubscriptions.model.StopProductSubscriptionRequest.ReadOnly =
    new Wrapper(impl)
}
