package zio.aws.licensemanagerusersubscriptions.model
import zio.aws.licensemanagerusersubscriptions.model.primitives.BoxInteger
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListInstancesRequest(
    filters: Optional[
      Iterable[zio.aws.licensemanagerusersubscriptions.model.Filter]
    ] = Optional.Absent,
    maxResults: Optional[BoxInteger] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListInstancesRequest = {
    import ListInstancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListInstancesRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.licensemanagerusersubscriptions.model.ListInstancesRequest.ReadOnly =
    zio.aws.licensemanagerusersubscriptions.model.ListInstancesRequest
      .wrap(buildAwsValue())
}
object ListInstancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListInstancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.licensemanagerusersubscriptions.model.ListInstancesRequest =
      zio.aws.licensemanagerusersubscriptions.model.ListInstancesRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def filters: Optional[
      List[zio.aws.licensemanagerusersubscriptions.model.Filter.ReadOnly]
    ]
    def maxResults: Optional[BoxInteger]
    def nextToken: Optional[String]
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.licensemanagerusersubscriptions.model.Filter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, BoxInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListInstancesRequest
  ) extends zio.aws.licensemanagerusersubscriptions.model.ListInstancesRequest.ReadOnly {
    override val filters: Optional[
      List[zio.aws.licensemanagerusersubscriptions.model.Filter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.licensemanagerusersubscriptions.model.Filter.wrap(item)
        }.toList
      )
    override val maxResults: Optional[BoxInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: BoxInteger)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListInstancesRequest
  ): zio.aws.licensemanagerusersubscriptions.model.ListInstancesRequest.ReadOnly =
    new Wrapper(impl)
}
