package zio.aws.licensemanagerusersubscriptions
import zio.aws.licensemanagerusersubscriptions.model.InstanceSummary.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.licensemanagerusersubscriptions.{
  LicenseManagerUserSubscriptionsAsyncClientBuilder,
  LicenseManagerUserSubscriptionsAsyncClient
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.{
  DisassociateUserRequest,
  ListUserAssociationsResponse,
  StopProductSubscriptionRequest,
  InstanceSummary,
  ListProductSubscriptionsRequest,
  ListInstancesResponse,
  DeregisterIdentityProviderResponse,
  ListIdentityProvidersResponse,
  InstanceUserSummary,
  StartProductSubscriptionResponse,
  ListIdentityProvidersRequest,
  ListUserAssociationsRequest,
  ListInstancesRequest,
  AssociateUserRequest,
  AssociateUserResponse,
  StartProductSubscriptionRequest,
  IdentityProviderSummary,
  ProductUserSummary,
  RegisterIdentityProviderRequest,
  DisassociateUserResponse,
  ListProductSubscriptionsResponse,
  DeregisterIdentityProviderRequest,
  StopProductSubscriptionResponse,
  RegisterIdentityProviderResponse
}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait LicenseManagerUserSubscriptions
    extends AspectSupport[LicenseManagerUserSubscriptions] {
  val api: LicenseManagerUserSubscriptionsAsyncClient
  def stopProductSubscription(
      request: zio.aws.licensemanagerusersubscriptions.model.StopProductSubscriptionRequest
  ): IO[
    AwsError,
    zio.aws.licensemanagerusersubscriptions.model.StopProductSubscriptionResponse.ReadOnly
  ]
  def disassociateUser(
      request: zio.aws.licensemanagerusersubscriptions.model.DisassociateUserRequest
  ): IO[
    AwsError,
    zio.aws.licensemanagerusersubscriptions.model.DisassociateUserResponse.ReadOnly
  ]
  def listProductSubscriptions(
      request: zio.aws.licensemanagerusersubscriptions.model.ListProductSubscriptionsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.licensemanagerusersubscriptions.model.ProductUserSummary.ReadOnly
  ]
  def listProductSubscriptionsPaginated(
      request: zio.aws.licensemanagerusersubscriptions.model.ListProductSubscriptionsRequest
  ): IO[
    AwsError,
    zio.aws.licensemanagerusersubscriptions.model.ListProductSubscriptionsResponse.ReadOnly
  ]
  def listInstances(
      request: zio.aws.licensemanagerusersubscriptions.model.ListInstancesRequest
  ): ZStream[Any, AwsError, ReadOnly]
  def listInstancesPaginated(
      request: zio.aws.licensemanagerusersubscriptions.model.ListInstancesRequest
  ): IO[
    AwsError,
    zio.aws.licensemanagerusersubscriptions.model.ListInstancesResponse.ReadOnly
  ]
  def registerIdentityProvider(
      request: zio.aws.licensemanagerusersubscriptions.model.RegisterIdentityProviderRequest
  ): IO[
    AwsError,
    zio.aws.licensemanagerusersubscriptions.model.RegisterIdentityProviderResponse.ReadOnly
  ]
  def listUserAssociations(
      request: zio.aws.licensemanagerusersubscriptions.model.ListUserAssociationsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.licensemanagerusersubscriptions.model.InstanceUserSummary.ReadOnly
  ]
  def listUserAssociationsPaginated(
      request: zio.aws.licensemanagerusersubscriptions.model.ListUserAssociationsRequest
  ): IO[
    AwsError,
    zio.aws.licensemanagerusersubscriptions.model.ListUserAssociationsResponse.ReadOnly
  ]
  def listIdentityProviders(
      request: zio.aws.licensemanagerusersubscriptions.model.ListIdentityProvidersRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.licensemanagerusersubscriptions.model.IdentityProviderSummary.ReadOnly
  ]
  def listIdentityProvidersPaginated(
      request: zio.aws.licensemanagerusersubscriptions.model.ListIdentityProvidersRequest
  ): IO[
    AwsError,
    zio.aws.licensemanagerusersubscriptions.model.ListIdentityProvidersResponse.ReadOnly
  ]
  def startProductSubscription(
      request: zio.aws.licensemanagerusersubscriptions.model.StartProductSubscriptionRequest
  ): IO[
    AwsError,
    zio.aws.licensemanagerusersubscriptions.model.StartProductSubscriptionResponse.ReadOnly
  ]
  def associateUser(
      request: zio.aws.licensemanagerusersubscriptions.model.AssociateUserRequest
  ): IO[
    AwsError,
    zio.aws.licensemanagerusersubscriptions.model.AssociateUserResponse.ReadOnly
  ]
  def deregisterIdentityProvider(
      request: zio.aws.licensemanagerusersubscriptions.model.DeregisterIdentityProviderRequest
  ): IO[
    AwsError,
    zio.aws.licensemanagerusersubscriptions.model.DeregisterIdentityProviderResponse.ReadOnly
  ]
}
object LicenseManagerUserSubscriptions {
  val live: ZLayer[
    AwsConfig,
    java.lang.Throwable,
    LicenseManagerUserSubscriptions
  ] = customized(identity)
  def customized(
      customization: LicenseManagerUserSubscriptionsAsyncClientBuilder => LicenseManagerUserSubscriptionsAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, LicenseManagerUserSubscriptions] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: LicenseManagerUserSubscriptionsAsyncClientBuilder => LicenseManagerUserSubscriptionsAsyncClientBuilder
  ): ZIO[
    AwsConfig with Scope,
    java.lang.Throwable,
    LicenseManagerUserSubscriptions
  ] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = LicenseManagerUserSubscriptionsAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[
      LicenseManagerUserSubscriptionsAsyncClient,
      LicenseManagerUserSubscriptionsAsyncClientBuilder
    ](builder);
    b1 <- awsConfig.configureHttpClient[
      LicenseManagerUserSubscriptionsAsyncClient,
      LicenseManagerUserSubscriptionsAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new LicenseManagerUserSubscriptionsImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class LicenseManagerUserSubscriptionsImpl[R](
      override val api: LicenseManagerUserSubscriptionsAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends LicenseManagerUserSubscriptions
      with AwsServiceBase[R] {
    override val serviceName: String = "LicenseManagerUserSubscriptions"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): LicenseManagerUserSubscriptionsImpl[R1] =
      new LicenseManagerUserSubscriptionsImpl(api, newAspect, r)
    def stopProductSubscription(
        request: zio.aws.licensemanagerusersubscriptions.model.StopProductSubscriptionRequest
    ): IO[
      AwsError,
      zio.aws.licensemanagerusersubscriptions.model.StopProductSubscriptionResponse.ReadOnly
    ] = asyncRequestResponse[
      StopProductSubscriptionRequest,
      StopProductSubscriptionResponse
    ]("stopProductSubscription", api.stopProductSubscription)(
      request.buildAwsValue()
    ).map(
      zio.aws.licensemanagerusersubscriptions.model.StopProductSubscriptionResponse.wrap
    ).provideEnvironment(r)
    def disassociateUser(
        request: zio.aws.licensemanagerusersubscriptions.model.DisassociateUserRequest
    ): IO[
      AwsError,
      zio.aws.licensemanagerusersubscriptions.model.DisassociateUserResponse.ReadOnly
    ] = asyncRequestResponse[DisassociateUserRequest, DisassociateUserResponse](
      "disassociateUser",
      api.disassociateUser
    )(request.buildAwsValue())
      .map(
        zio.aws.licensemanagerusersubscriptions.model.DisassociateUserResponse.wrap
      )
      .provideEnvironment(r)
    def listProductSubscriptions(
        request: zio.aws.licensemanagerusersubscriptions.model.ListProductSubscriptionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.licensemanagerusersubscriptions.model.ProductUserSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListProductSubscriptionsRequest,
      ListProductSubscriptionsResponse,
      ProductUserSummary
    ](
      "listProductSubscriptions",
      api.listProductSubscriptions,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.productUserSummaries().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.licensemanagerusersubscriptions.model.ProductUserSummary
          .wrap(item)
      )
      .provideEnvironment(r)
    def listProductSubscriptionsPaginated(
        request: zio.aws.licensemanagerusersubscriptions.model.ListProductSubscriptionsRequest
    ): IO[
      AwsError,
      zio.aws.licensemanagerusersubscriptions.model.ListProductSubscriptionsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListProductSubscriptionsRequest,
      ListProductSubscriptionsResponse
    ]("listProductSubscriptions", api.listProductSubscriptions)(
      request.buildAwsValue()
    ).map(
      zio.aws.licensemanagerusersubscriptions.model.ListProductSubscriptionsResponse.wrap
    ).provideEnvironment(r)
    def listInstances(
        request: zio.aws.licensemanagerusersubscriptions.model.ListInstancesRequest
    ): ZStream[Any, AwsError, ReadOnly] = asyncSimplePaginatedRequest[
      ListInstancesRequest,
      ListInstancesResponse,
      InstanceSummary
    ](
      "listInstances",
      api.listInstances,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.instanceSummaries().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.licensemanagerusersubscriptions.model.InstanceSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listInstancesPaginated(
        request: zio.aws.licensemanagerusersubscriptions.model.ListInstancesRequest
    ): IO[
      AwsError,
      zio.aws.licensemanagerusersubscriptions.model.ListInstancesResponse.ReadOnly
    ] = asyncRequestResponse[ListInstancesRequest, ListInstancesResponse](
      "listInstances",
      api.listInstances
    )(request.buildAwsValue())
      .map(
        zio.aws.licensemanagerusersubscriptions.model.ListInstancesResponse.wrap
      )
      .provideEnvironment(r)
    def registerIdentityProvider(
        request: zio.aws.licensemanagerusersubscriptions.model.RegisterIdentityProviderRequest
    ): IO[
      AwsError,
      zio.aws.licensemanagerusersubscriptions.model.RegisterIdentityProviderResponse.ReadOnly
    ] = asyncRequestResponse[
      RegisterIdentityProviderRequest,
      RegisterIdentityProviderResponse
    ]("registerIdentityProvider", api.registerIdentityProvider)(
      request.buildAwsValue()
    ).map(
      zio.aws.licensemanagerusersubscriptions.model.RegisterIdentityProviderResponse.wrap
    ).provideEnvironment(r)
    def listUserAssociations(
        request: zio.aws.licensemanagerusersubscriptions.model.ListUserAssociationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.licensemanagerusersubscriptions.model.InstanceUserSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListUserAssociationsRequest,
      ListUserAssociationsResponse,
      InstanceUserSummary
    ](
      "listUserAssociations",
      api.listUserAssociations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.instanceUserSummaries().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.licensemanagerusersubscriptions.model.InstanceUserSummary
          .wrap(item)
      )
      .provideEnvironment(r)
    def listUserAssociationsPaginated(
        request: zio.aws.licensemanagerusersubscriptions.model.ListUserAssociationsRequest
    ): IO[
      AwsError,
      zio.aws.licensemanagerusersubscriptions.model.ListUserAssociationsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListUserAssociationsRequest,
      ListUserAssociationsResponse
    ]("listUserAssociations", api.listUserAssociations)(request.buildAwsValue())
      .map(
        zio.aws.licensemanagerusersubscriptions.model.ListUserAssociationsResponse.wrap
      )
      .provideEnvironment(r)
    def listIdentityProviders(
        request: zio.aws.licensemanagerusersubscriptions.model.ListIdentityProvidersRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.licensemanagerusersubscriptions.model.IdentityProviderSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListIdentityProvidersRequest,
      ListIdentityProvidersResponse,
      IdentityProviderSummary
    ](
      "listIdentityProviders",
      api.listIdentityProviders,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.identityProviderSummaries().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.licensemanagerusersubscriptions.model.IdentityProviderSummary
          .wrap(item)
      )
      .provideEnvironment(r)
    def listIdentityProvidersPaginated(
        request: zio.aws.licensemanagerusersubscriptions.model.ListIdentityProvidersRequest
    ): IO[
      AwsError,
      zio.aws.licensemanagerusersubscriptions.model.ListIdentityProvidersResponse.ReadOnly
    ] = asyncRequestResponse[
      ListIdentityProvidersRequest,
      ListIdentityProvidersResponse
    ]("listIdentityProviders", api.listIdentityProviders)(
      request.buildAwsValue()
    ).map(
      zio.aws.licensemanagerusersubscriptions.model.ListIdentityProvidersResponse.wrap
    ).provideEnvironment(r)
    def startProductSubscription(
        request: zio.aws.licensemanagerusersubscriptions.model.StartProductSubscriptionRequest
    ): IO[
      AwsError,
      zio.aws.licensemanagerusersubscriptions.model.StartProductSubscriptionResponse.ReadOnly
    ] = asyncRequestResponse[
      StartProductSubscriptionRequest,
      StartProductSubscriptionResponse
    ]("startProductSubscription", api.startProductSubscription)(
      request.buildAwsValue()
    ).map(
      zio.aws.licensemanagerusersubscriptions.model.StartProductSubscriptionResponse.wrap
    ).provideEnvironment(r)
    def associateUser(
        request: zio.aws.licensemanagerusersubscriptions.model.AssociateUserRequest
    ): IO[
      AwsError,
      zio.aws.licensemanagerusersubscriptions.model.AssociateUserResponse.ReadOnly
    ] = asyncRequestResponse[AssociateUserRequest, AssociateUserResponse](
      "associateUser",
      api.associateUser
    )(request.buildAwsValue())
      .map(
        zio.aws.licensemanagerusersubscriptions.model.AssociateUserResponse.wrap
      )
      .provideEnvironment(r)
    def deregisterIdentityProvider(
        request: zio.aws.licensemanagerusersubscriptions.model.DeregisterIdentityProviderRequest
    ): IO[
      AwsError,
      zio.aws.licensemanagerusersubscriptions.model.DeregisterIdentityProviderResponse.ReadOnly
    ] = asyncRequestResponse[
      DeregisterIdentityProviderRequest,
      DeregisterIdentityProviderResponse
    ]("deregisterIdentityProvider", api.deregisterIdentityProvider)(
      request.buildAwsValue()
    ).map(
      zio.aws.licensemanagerusersubscriptions.model.DeregisterIdentityProviderResponse.wrap
    ).provideEnvironment(r)
  }
  def stopProductSubscription(
      request: zio.aws.licensemanagerusersubscriptions.model.StopProductSubscriptionRequest
  ): ZIO[
    zio.aws.licensemanagerusersubscriptions.LicenseManagerUserSubscriptions,
    AwsError,
    zio.aws.licensemanagerusersubscriptions.model.StopProductSubscriptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopProductSubscription(request))
  def disassociateUser(
      request: zio.aws.licensemanagerusersubscriptions.model.DisassociateUserRequest
  ): ZIO[
    zio.aws.licensemanagerusersubscriptions.LicenseManagerUserSubscriptions,
    AwsError,
    zio.aws.licensemanagerusersubscriptions.model.DisassociateUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateUser(request))
  def listProductSubscriptions(
      request: zio.aws.licensemanagerusersubscriptions.model.ListProductSubscriptionsRequest
  ): ZStream[
    zio.aws.licensemanagerusersubscriptions.LicenseManagerUserSubscriptions,
    AwsError,
    zio.aws.licensemanagerusersubscriptions.model.ProductUserSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listProductSubscriptions(request))
  def listProductSubscriptionsPaginated(
      request: zio.aws.licensemanagerusersubscriptions.model.ListProductSubscriptionsRequest
  ): ZIO[
    zio.aws.licensemanagerusersubscriptions.LicenseManagerUserSubscriptions,
    AwsError,
    zio.aws.licensemanagerusersubscriptions.model.ListProductSubscriptionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listProductSubscriptionsPaginated(request))
  def listInstances(
      request: zio.aws.licensemanagerusersubscriptions.model.ListInstancesRequest
  ): ZStream[
    zio.aws.licensemanagerusersubscriptions.LicenseManagerUserSubscriptions,
    AwsError,
    ReadOnly
  ] = ZStream.serviceWithStream(_.listInstances(request))
  def listInstancesPaginated(
      request: zio.aws.licensemanagerusersubscriptions.model.ListInstancesRequest
  ): ZIO[
    zio.aws.licensemanagerusersubscriptions.LicenseManagerUserSubscriptions,
    AwsError,
    zio.aws.licensemanagerusersubscriptions.model.ListInstancesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listInstancesPaginated(request))
  def registerIdentityProvider(
      request: zio.aws.licensemanagerusersubscriptions.model.RegisterIdentityProviderRequest
  ): ZIO[
    zio.aws.licensemanagerusersubscriptions.LicenseManagerUserSubscriptions,
    AwsError,
    zio.aws.licensemanagerusersubscriptions.model.RegisterIdentityProviderResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.registerIdentityProvider(request))
  def listUserAssociations(
      request: zio.aws.licensemanagerusersubscriptions.model.ListUserAssociationsRequest
  ): ZStream[
    zio.aws.licensemanagerusersubscriptions.LicenseManagerUserSubscriptions,
    AwsError,
    zio.aws.licensemanagerusersubscriptions.model.InstanceUserSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listUserAssociations(request))
  def listUserAssociationsPaginated(
      request: zio.aws.licensemanagerusersubscriptions.model.ListUserAssociationsRequest
  ): ZIO[
    zio.aws.licensemanagerusersubscriptions.LicenseManagerUserSubscriptions,
    AwsError,
    zio.aws.licensemanagerusersubscriptions.model.ListUserAssociationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listUserAssociationsPaginated(request))
  def listIdentityProviders(
      request: zio.aws.licensemanagerusersubscriptions.model.ListIdentityProvidersRequest
  ): ZStream[
    zio.aws.licensemanagerusersubscriptions.LicenseManagerUserSubscriptions,
    AwsError,
    zio.aws.licensemanagerusersubscriptions.model.IdentityProviderSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listIdentityProviders(request))
  def listIdentityProvidersPaginated(
      request: zio.aws.licensemanagerusersubscriptions.model.ListIdentityProvidersRequest
  ): ZIO[
    zio.aws.licensemanagerusersubscriptions.LicenseManagerUserSubscriptions,
    AwsError,
    zio.aws.licensemanagerusersubscriptions.model.ListIdentityProvidersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listIdentityProvidersPaginated(request))
  def startProductSubscription(
      request: zio.aws.licensemanagerusersubscriptions.model.StartProductSubscriptionRequest
  ): ZIO[
    zio.aws.licensemanagerusersubscriptions.LicenseManagerUserSubscriptions,
    AwsError,
    zio.aws.licensemanagerusersubscriptions.model.StartProductSubscriptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startProductSubscription(request))
  def associateUser(
      request: zio.aws.licensemanagerusersubscriptions.model.AssociateUserRequest
  ): ZIO[
    zio.aws.licensemanagerusersubscriptions.LicenseManagerUserSubscriptions,
    AwsError,
    zio.aws.licensemanagerusersubscriptions.model.AssociateUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateUser(request))
  def deregisterIdentityProvider(
      request: zio.aws.licensemanagerusersubscriptions.model.DeregisterIdentityProviderRequest
  ): ZIO[
    zio.aws.licensemanagerusersubscriptions.LicenseManagerUserSubscriptions,
    AwsError,
    zio.aws.licensemanagerusersubscriptions.model.DeregisterIdentityProviderResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deregisterIdentityProvider(request))
}
