package zio.aws.licensemanagerusersubscriptions.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InstanceSummary(
    instanceId: String,
    lastStatusCheckDate: Optional[String] = Optional.Absent,
    products: Iterable[String],
    status: String,
    statusMessage: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanagerusersubscriptions.model.InstanceSummary = {
    import InstanceSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanagerusersubscriptions.model.InstanceSummary
      .builder()
      .instanceId(instanceId: java.lang.String)
      .optionallyWith(
        lastStatusCheckDate.map(value => value: java.lang.String)
      )(_.lastStatusCheckDate)
      .products(products.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .status(status: java.lang.String)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .build()
  }
  def asReadOnly
      : zio.aws.licensemanagerusersubscriptions.model.InstanceSummary.ReadOnly =
    zio.aws.licensemanagerusersubscriptions.model.InstanceSummary
      .wrap(buildAwsValue())
}
object InstanceSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanagerusersubscriptions.model.InstanceSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.licensemanagerusersubscriptions.model.InstanceSummary =
      zio.aws.licensemanagerusersubscriptions.model.InstanceSummary(
        instanceId,
        lastStatusCheckDate.map(value => value),
        products,
        status,
        statusMessage.map(value => value)
      )
    def instanceId: String
    def lastStatusCheckDate: Optional[String]
    def products: List[String]
    def status: String
    def statusMessage: Optional[String]
    def getInstanceId: ZIO[Any, Nothing, String] = ZIO.succeed(instanceId)
    def getLastStatusCheckDate: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lastStatusCheckDate", lastStatusCheckDate)
    def getProducts: ZIO[Any, Nothing, List[String]] = ZIO.succeed(products)
    def getStatus: ZIO[Any, Nothing, String] = ZIO.succeed(status)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.licensemanagerusersubscriptions.model.InstanceSummary
  ) extends zio.aws.licensemanagerusersubscriptions.model.InstanceSummary.ReadOnly {
    override val instanceId: String = impl.instanceId(): String
    override val lastStatusCheckDate: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.lastStatusCheckDate())
      .map(value => value: String)
    override val products: List[String] = impl
      .products()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val status: String = impl.status(): String
    override val statusMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanagerusersubscriptions.model.InstanceSummary
  ): zio.aws.licensemanagerusersubscriptions.model.InstanceSummary.ReadOnly =
    new Wrapper(impl)
}
