package zio.aws.licensemanagerusersubscriptions.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Filter(
    attribute: Optional[String] = Optional.Absent,
    operation: Optional[String] = Optional.Absent,
    value: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanagerusersubscriptions.model.Filter = {
    import Filter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanagerusersubscriptions.model.Filter
      .builder()
      .optionallyWith(attribute.map(value => value: java.lang.String))(
        _.attribute
      )
      .optionallyWith(operation.map(value => value: java.lang.String))(
        _.operation
      )
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .build()
  }
  def asReadOnly
      : zio.aws.licensemanagerusersubscriptions.model.Filter.ReadOnly =
    zio.aws.licensemanagerusersubscriptions.model.Filter.wrap(buildAwsValue())
}
object Filter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanagerusersubscriptions.model.Filter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.licensemanagerusersubscriptions.model.Filter =
      zio.aws.licensemanagerusersubscriptions.model.Filter(
        attribute.map(value => value),
        operation.map(value => value),
        value.map(value => value)
      )
    def attribute: Optional[String]
    def operation: Optional[String]
    def value: Optional[String]
    def getAttribute: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("attribute", attribute)
    def getOperation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("operation", operation)
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.licensemanagerusersubscriptions.model.Filter
  ) extends zio.aws.licensemanagerusersubscriptions.model.Filter.ReadOnly {
    override val attribute: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.attribute())
      .map(value => value: String)
    override val operation: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.operation())
      .map(value => value: String)
    override val value: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanagerusersubscriptions.model.Filter
  ): zio.aws.licensemanagerusersubscriptions.model.Filter.ReadOnly =
    new Wrapper(impl)
}
