package zio.aws.licensemanagerusersubscriptions.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListProductSubscriptionsResponse(
    nextToken: Optional[String] = Optional.Absent,
    productUserSummaries: Optional[
      Iterable[zio.aws.licensemanagerusersubscriptions.model.ProductUserSummary]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListProductSubscriptionsResponse = {
    import ListProductSubscriptionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListProductSubscriptionsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        productUserSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.productUserSummaries)
      .build()
  }
  def asReadOnly
      : zio.aws.licensemanagerusersubscriptions.model.ListProductSubscriptionsResponse.ReadOnly =
    zio.aws.licensemanagerusersubscriptions.model.ListProductSubscriptionsResponse
      .wrap(buildAwsValue())
}
object ListProductSubscriptionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListProductSubscriptionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.licensemanagerusersubscriptions.model.ListProductSubscriptionsResponse =
      zio.aws.licensemanagerusersubscriptions.model
        .ListProductSubscriptionsResponse(
          nextToken.map(value => value),
          productUserSummaries.map(value =>
            value.map { item =>
              item.asEditable
            }
          )
        )
    def nextToken: Optional[String]
    def productUserSummaries: Optional[List[
      zio.aws.licensemanagerusersubscriptions.model.ProductUserSummary.ReadOnly
    ]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getProductUserSummaries: ZIO[Any, AwsError, List[
      zio.aws.licensemanagerusersubscriptions.model.ProductUserSummary.ReadOnly
    ]] =
      AwsError.unwrapOptionField("productUserSummaries", productUserSummaries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListProductSubscriptionsResponse
  ) extends zio.aws.licensemanagerusersubscriptions.model.ListProductSubscriptionsResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val productUserSummaries: Optional[List[
      zio.aws.licensemanagerusersubscriptions.model.ProductUserSummary.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.productUserSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.licensemanagerusersubscriptions.model.ProductUserSummary
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListProductSubscriptionsResponse
  ): zio.aws.licensemanagerusersubscriptions.model.ListProductSubscriptionsResponse.ReadOnly =
    new Wrapper(impl)
}
