package zio.aws.licensemanagerusersubscriptions.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeregisterIdentityProviderRequest(
    identityProvider: zio.aws.licensemanagerusersubscriptions.model.IdentityProvider,
    product: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanagerusersubscriptions.model.DeregisterIdentityProviderRequest = {
    import DeregisterIdentityProviderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanagerusersubscriptions.model.DeregisterIdentityProviderRequest
      .builder()
      .identityProvider(identityProvider.buildAwsValue())
      .product(product: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.licensemanagerusersubscriptions.model.DeregisterIdentityProviderRequest.ReadOnly =
    zio.aws.licensemanagerusersubscriptions.model.DeregisterIdentityProviderRequest
      .wrap(buildAwsValue())
}
object DeregisterIdentityProviderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanagerusersubscriptions.model.DeregisterIdentityProviderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.licensemanagerusersubscriptions.model.DeregisterIdentityProviderRequest =
      zio.aws.licensemanagerusersubscriptions.model
        .DeregisterIdentityProviderRequest(identityProvider.asEditable, product)
    def identityProvider
        : zio.aws.licensemanagerusersubscriptions.model.IdentityProvider.ReadOnly
    def product: String
    def getIdentityProvider: ZIO[
      Any,
      Nothing,
      zio.aws.licensemanagerusersubscriptions.model.IdentityProvider.ReadOnly
    ] = ZIO.succeed(identityProvider)
    def getProduct: ZIO[Any, Nothing, String] = ZIO.succeed(product)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.licensemanagerusersubscriptions.model.DeregisterIdentityProviderRequest
  ) extends zio.aws.licensemanagerusersubscriptions.model.DeregisterIdentityProviderRequest.ReadOnly {
    override val identityProvider
        : zio.aws.licensemanagerusersubscriptions.model.IdentityProvider.ReadOnly =
      zio.aws.licensemanagerusersubscriptions.model.IdentityProvider
        .wrap(impl.identityProvider())
    override val product: String = impl.product(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanagerusersubscriptions.model.DeregisterIdentityProviderRequest
  ): zio.aws.licensemanagerusersubscriptions.model.DeregisterIdentityProviderRequest.ReadOnly =
    new Wrapper(impl)
}
