package zio.aws.licensemanagerusersubscriptions.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.licensemanagerusersubscriptions.model.primitives.{
  SecurityGroup,
  Subnet
}
import scala.jdk.CollectionConverters._
final case class UpdateSettings(
    addSubnets: Iterable[Subnet],
    removeSubnets: Iterable[Subnet],
    securityGroupId: Optional[SecurityGroup] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanagerusersubscriptions.model.UpdateSettings = {
    import UpdateSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanagerusersubscriptions.model.UpdateSettings
      .builder()
      .addSubnets(addSubnets.map { item =>
        Subnet.unwrap(item): java.lang.String
      }.asJavaCollection)
      .removeSubnets(removeSubnets.map { item =>
        Subnet.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        securityGroupId.map(value =>
          SecurityGroup.unwrap(value): java.lang.String
        )
      )(_.securityGroupId)
      .build()
  }
  def asReadOnly
      : zio.aws.licensemanagerusersubscriptions.model.UpdateSettings.ReadOnly =
    zio.aws.licensemanagerusersubscriptions.model.UpdateSettings
      .wrap(buildAwsValue())
}
object UpdateSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanagerusersubscriptions.model.UpdateSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.licensemanagerusersubscriptions.model.UpdateSettings =
      zio.aws.licensemanagerusersubscriptions.model.UpdateSettings(
        addSubnets,
        removeSubnets,
        securityGroupId.map(value => value)
      )
    def addSubnets: List[Subnet]
    def removeSubnets: List[Subnet]
    def securityGroupId: Optional[SecurityGroup]
    def getAddSubnets: ZIO[Any, Nothing, List[Subnet]] = ZIO.succeed(addSubnets)
    def getRemoveSubnets: ZIO[Any, Nothing, List[Subnet]] =
      ZIO.succeed(removeSubnets)
    def getSecurityGroupId: ZIO[Any, AwsError, SecurityGroup] =
      AwsError.unwrapOptionField("securityGroupId", securityGroupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.licensemanagerusersubscriptions.model.UpdateSettings
  ) extends zio.aws.licensemanagerusersubscriptions.model.UpdateSettings.ReadOnly {
    override val addSubnets: List[Subnet] = impl
      .addSubnets()
      .asScala
      .map { item =>
        zio.aws.licensemanagerusersubscriptions.model.primitives.Subnet(item)
      }
      .toList
    override val removeSubnets: List[Subnet] = impl
      .removeSubnets()
      .asScala
      .map { item =>
        zio.aws.licensemanagerusersubscriptions.model.primitives.Subnet(item)
      }
      .toList
    override val securityGroupId: Optional[SecurityGroup] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupId())
        .map(value =>
          zio.aws.licensemanagerusersubscriptions.model.primitives
            .SecurityGroup(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanagerusersubscriptions.model.UpdateSettings
  ): zio.aws.licensemanagerusersubscriptions.model.UpdateSettings.ReadOnly =
    new Wrapper(impl)
}
