package zio.aws.licensemanagerusersubscriptions.model
import zio.aws.licensemanagerusersubscriptions.model.primitives.BoxInteger
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListUserAssociationsRequest(
    filters: Optional[
      Iterable[zio.aws.licensemanagerusersubscriptions.model.Filter]
    ] = Optional.Absent,
    identityProvider: zio.aws.licensemanagerusersubscriptions.model.IdentityProvider,
    instanceId: String,
    maxResults: Optional[BoxInteger] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListUserAssociationsRequest = {
    import ListUserAssociationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListUserAssociationsRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .identityProvider(identityProvider.buildAwsValue())
      .instanceId(instanceId: java.lang.String)
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.licensemanagerusersubscriptions.model.ListUserAssociationsRequest.ReadOnly =
    zio.aws.licensemanagerusersubscriptions.model.ListUserAssociationsRequest
      .wrap(buildAwsValue())
}
object ListUserAssociationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListUserAssociationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.licensemanagerusersubscriptions.model.ListUserAssociationsRequest =
      zio.aws.licensemanagerusersubscriptions.model.ListUserAssociationsRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        identityProvider.asEditable,
        instanceId,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def filters: Optional[
      List[zio.aws.licensemanagerusersubscriptions.model.Filter.ReadOnly]
    ]
    def identityProvider
        : zio.aws.licensemanagerusersubscriptions.model.IdentityProvider.ReadOnly
    def instanceId: String
    def maxResults: Optional[BoxInteger]
    def nextToken: Optional[String]
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.licensemanagerusersubscriptions.model.Filter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getIdentityProvider: ZIO[
      Any,
      Nothing,
      zio.aws.licensemanagerusersubscriptions.model.IdentityProvider.ReadOnly
    ] = ZIO.succeed(identityProvider)
    def getInstanceId: ZIO[Any, Nothing, String] = ZIO.succeed(instanceId)
    def getMaxResults: ZIO[Any, AwsError, BoxInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListUserAssociationsRequest
  ) extends zio.aws.licensemanagerusersubscriptions.model.ListUserAssociationsRequest.ReadOnly {
    override val filters: Optional[
      List[zio.aws.licensemanagerusersubscriptions.model.Filter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.licensemanagerusersubscriptions.model.Filter.wrap(item)
        }.toList
      )
    override val identityProvider
        : zio.aws.licensemanagerusersubscriptions.model.IdentityProvider.ReadOnly =
      zio.aws.licensemanagerusersubscriptions.model.IdentityProvider
        .wrap(impl.identityProvider())
    override val instanceId: String = impl.instanceId(): String
    override val maxResults: Optional[BoxInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: BoxInteger)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListUserAssociationsRequest
  ): zio.aws.licensemanagerusersubscriptions.model.ListUserAssociationsRequest.ReadOnly =
    new Wrapper(impl)
}
