package zio.aws.licensemanagerusersubscriptions.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListInstancesResponse(
    instanceSummaries: Optional[
      Iterable[zio.aws.licensemanagerusersubscriptions.model.InstanceSummary]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListInstancesResponse = {
    import ListInstancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListInstancesResponse
      .builder()
      .optionallyWith(
        instanceSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instanceSummaries)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.licensemanagerusersubscriptions.model.ListInstancesResponse.ReadOnly =
    zio.aws.licensemanagerusersubscriptions.model.ListInstancesResponse
      .wrap(buildAwsValue())
}
object ListInstancesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListInstancesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.licensemanagerusersubscriptions.model.ListInstancesResponse =
      zio.aws.licensemanagerusersubscriptions.model.ListInstancesResponse(
        instanceSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def instanceSummaries: Optional[List[
      zio.aws.licensemanagerusersubscriptions.model.InstanceSummary.ReadOnly
    ]]
    def nextToken: Optional[String]
    def getInstanceSummaries: ZIO[Any, AwsError, List[
      zio.aws.licensemanagerusersubscriptions.model.InstanceSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("instanceSummaries", instanceSummaries)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListInstancesResponse
  ) extends zio.aws.licensemanagerusersubscriptions.model.ListInstancesResponse.ReadOnly {
    override val instanceSummaries: Optional[List[
      zio.aws.licensemanagerusersubscriptions.model.InstanceSummary.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.licensemanagerusersubscriptions.model.InstanceSummary
            .wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListInstancesResponse
  ): zio.aws.licensemanagerusersubscriptions.model.ListInstancesResponse.ReadOnly =
    new Wrapper(impl)
}
