package zio.aws.licensemanagerusersubscriptions.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListUserAssociationsResponse(
    instanceUserSummaries: Optional[Iterable[
      zio.aws.licensemanagerusersubscriptions.model.InstanceUserSummary
    ]] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListUserAssociationsResponse = {
    import ListUserAssociationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListUserAssociationsResponse
      .builder()
      .optionallyWith(
        instanceUserSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instanceUserSummaries)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.licensemanagerusersubscriptions.model.ListUserAssociationsResponse.ReadOnly =
    zio.aws.licensemanagerusersubscriptions.model.ListUserAssociationsResponse
      .wrap(buildAwsValue())
}
object ListUserAssociationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListUserAssociationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.licensemanagerusersubscriptions.model.ListUserAssociationsResponse =
      zio.aws.licensemanagerusersubscriptions.model
        .ListUserAssociationsResponse(
          instanceUserSummaries.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          nextToken.map(value => value)
        )
    def instanceUserSummaries: Optional[List[
      zio.aws.licensemanagerusersubscriptions.model.InstanceUserSummary.ReadOnly
    ]]
    def nextToken: Optional[String]
    def getInstanceUserSummaries: ZIO[Any, AwsError, List[
      zio.aws.licensemanagerusersubscriptions.model.InstanceUserSummary.ReadOnly
    ]] =
      AwsError.unwrapOptionField("instanceUserSummaries", instanceUserSummaries)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListUserAssociationsResponse
  ) extends zio.aws.licensemanagerusersubscriptions.model.ListUserAssociationsResponse.ReadOnly {
    override val instanceUserSummaries: Optional[List[
      zio.aws.licensemanagerusersubscriptions.model.InstanceUserSummary.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceUserSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.licensemanagerusersubscriptions.model.InstanceUserSummary
            .wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListUserAssociationsResponse
  ): zio.aws.licensemanagerusersubscriptions.model.ListUserAssociationsResponse.ReadOnly =
    new Wrapper(impl)
}
