package zio.aws.licensemanagerusersubscriptions.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListIdentityProvidersResponse(
    identityProviderSummaries: Iterable[
      zio.aws.licensemanagerusersubscriptions.model.IdentityProviderSummary
    ],
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListIdentityProvidersResponse = {
    import ListIdentityProvidersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListIdentityProvidersResponse
      .builder()
      .identityProviderSummaries(identityProviderSummaries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.licensemanagerusersubscriptions.model.ListIdentityProvidersResponse.ReadOnly =
    zio.aws.licensemanagerusersubscriptions.model.ListIdentityProvidersResponse
      .wrap(buildAwsValue())
}
object ListIdentityProvidersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListIdentityProvidersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.licensemanagerusersubscriptions.model.ListIdentityProvidersResponse =
      zio.aws.licensemanagerusersubscriptions.model
        .ListIdentityProvidersResponse(
          identityProviderSummaries.map { item =>
            item.asEditable
          },
          nextToken.map(value => value)
        )
    def identityProviderSummaries: List[
      zio.aws.licensemanagerusersubscriptions.model.IdentityProviderSummary.ReadOnly
    ]
    def nextToken: Optional[String]
    def getIdentityProviderSummaries: ZIO[Any, Nothing, List[
      zio.aws.licensemanagerusersubscriptions.model.IdentityProviderSummary.ReadOnly
    ]] = ZIO.succeed(identityProviderSummaries)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListIdentityProvidersResponse
  ) extends zio.aws.licensemanagerusersubscriptions.model.ListIdentityProvidersResponse.ReadOnly {
    override val identityProviderSummaries: List[
      zio.aws.licensemanagerusersubscriptions.model.IdentityProviderSummary.ReadOnly
    ] = impl
      .identityProviderSummaries()
      .asScala
      .map { item =>
        zio.aws.licensemanagerusersubscriptions.model.IdentityProviderSummary
          .wrap(item)
      }
      .toList
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListIdentityProvidersResponse
  ): zio.aws.licensemanagerusersubscriptions.model.ListIdentityProvidersResponse.ReadOnly =
    new Wrapper(impl)
}
