package zio.aws.licensemanagerusersubscriptions.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InstanceUserSummary(
    associationDate: Optional[String] = Optional.Absent,
    disassociationDate: Optional[String] = Optional.Absent,
    domain: Optional[String] = Optional.Absent,
    identityProvider: zio.aws.licensemanagerusersubscriptions.model.IdentityProvider,
    instanceId: String,
    status: String,
    statusMessage: Optional[String] = Optional.Absent,
    username: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanagerusersubscriptions.model.InstanceUserSummary = {
    import InstanceUserSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanagerusersubscriptions.model.InstanceUserSummary
      .builder()
      .optionallyWith(associationDate.map(value => value: java.lang.String))(
        _.associationDate
      )
      .optionallyWith(disassociationDate.map(value => value: java.lang.String))(
        _.disassociationDate
      )
      .optionallyWith(domain.map(value => value: java.lang.String))(_.domain)
      .identityProvider(identityProvider.buildAwsValue())
      .instanceId(instanceId: java.lang.String)
      .status(status: java.lang.String)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .username(username: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.licensemanagerusersubscriptions.model.InstanceUserSummary.ReadOnly =
    zio.aws.licensemanagerusersubscriptions.model.InstanceUserSummary
      .wrap(buildAwsValue())
}
object InstanceUserSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanagerusersubscriptions.model.InstanceUserSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.licensemanagerusersubscriptions.model.InstanceUserSummary =
      zio.aws.licensemanagerusersubscriptions.model.InstanceUserSummary(
        associationDate.map(value => value),
        disassociationDate.map(value => value),
        domain.map(value => value),
        identityProvider.asEditable,
        instanceId,
        status,
        statusMessage.map(value => value),
        username
      )
    def associationDate: Optional[String]
    def disassociationDate: Optional[String]
    def domain: Optional[String]
    def identityProvider
        : zio.aws.licensemanagerusersubscriptions.model.IdentityProvider.ReadOnly
    def instanceId: String
    def status: String
    def statusMessage: Optional[String]
    def username: String
    def getAssociationDate: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("associationDate", associationDate)
    def getDisassociationDate: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("disassociationDate", disassociationDate)
    def getDomain: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("domain", domain)
    def getIdentityProvider: ZIO[
      Any,
      Nothing,
      zio.aws.licensemanagerusersubscriptions.model.IdentityProvider.ReadOnly
    ] = ZIO.succeed(identityProvider)
    def getInstanceId: ZIO[Any, Nothing, String] = ZIO.succeed(instanceId)
    def getStatus: ZIO[Any, Nothing, String] = ZIO.succeed(status)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getUsername: ZIO[Any, Nothing, String] = ZIO.succeed(username)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.licensemanagerusersubscriptions.model.InstanceUserSummary
  ) extends zio.aws.licensemanagerusersubscriptions.model.InstanceUserSummary.ReadOnly {
    override val associationDate: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.associationDate())
      .map(value => value: String)
    override val disassociationDate: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.disassociationDate())
      .map(value => value: String)
    override val domain: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.domain())
      .map(value => value: String)
    override val identityProvider
        : zio.aws.licensemanagerusersubscriptions.model.IdentityProvider.ReadOnly =
      zio.aws.licensemanagerusersubscriptions.model.IdentityProvider
        .wrap(impl.identityProvider())
    override val instanceId: String = impl.instanceId(): String
    override val status: String = impl.status(): String
    override val statusMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => value: String)
    override val username: String = impl.username(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanagerusersubscriptions.model.InstanceUserSummary
  ): zio.aws.licensemanagerusersubscriptions.model.InstanceUserSummary.ReadOnly =
    new Wrapper(impl)
}
