package zio.aws.licensemanagerusersubscriptions
import zio.aws.licensemanagerusersubscriptions.model.InstanceSummary.ReadOnly
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.licensemanagerusersubscriptions.LicenseManagerUserSubscriptionsAsyncClient
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.licensemanagerusersubscriptions.model.{
  DisassociateUserRequest,
  StopProductSubscriptionRequest,
  ListProductSubscriptionsRequest,
  ListIdentityProvidersRequest,
  ListUserAssociationsRequest,
  ListInstancesRequest,
  AssociateUserRequest,
  StartProductSubscriptionRequest,
  RegisterIdentityProviderRequest,
  DeregisterIdentityProviderRequest
}
import zio.stream.ZStream
object LicenseManagerUserSubscriptionsMock
    extends Mock[LicenseManagerUserSubscriptions] {
  object StopProductSubscription
      extends Effect[
        StopProductSubscriptionRequest,
        AwsError,
        zio.aws.licensemanagerusersubscriptions.model.StopProductSubscriptionResponse.ReadOnly
      ]
  object DisassociateUser
      extends Effect[
        DisassociateUserRequest,
        AwsError,
        zio.aws.licensemanagerusersubscriptions.model.DisassociateUserResponse.ReadOnly
      ]
  object ListProductSubscriptions
      extends Stream[
        ListProductSubscriptionsRequest,
        AwsError,
        zio.aws.licensemanagerusersubscriptions.model.ProductUserSummary.ReadOnly
      ]
  object ListProductSubscriptionsPaginated
      extends Effect[
        ListProductSubscriptionsRequest,
        AwsError,
        zio.aws.licensemanagerusersubscriptions.model.ListProductSubscriptionsResponse.ReadOnly
      ]
  object ListInstances extends Stream[ListInstancesRequest, AwsError, ReadOnly]
  object ListInstancesPaginated
      extends Effect[
        ListInstancesRequest,
        AwsError,
        zio.aws.licensemanagerusersubscriptions.model.ListInstancesResponse.ReadOnly
      ]
  object RegisterIdentityProvider
      extends Effect[
        RegisterIdentityProviderRequest,
        AwsError,
        zio.aws.licensemanagerusersubscriptions.model.RegisterIdentityProviderResponse.ReadOnly
      ]
  object ListUserAssociations
      extends Stream[
        ListUserAssociationsRequest,
        AwsError,
        zio.aws.licensemanagerusersubscriptions.model.InstanceUserSummary.ReadOnly
      ]
  object ListUserAssociationsPaginated
      extends Effect[
        ListUserAssociationsRequest,
        AwsError,
        zio.aws.licensemanagerusersubscriptions.model.ListUserAssociationsResponse.ReadOnly
      ]
  object ListIdentityProviders
      extends Stream[
        ListIdentityProvidersRequest,
        AwsError,
        zio.aws.licensemanagerusersubscriptions.model.IdentityProviderSummary.ReadOnly
      ]
  object ListIdentityProvidersPaginated
      extends Effect[
        ListIdentityProvidersRequest,
        AwsError,
        zio.aws.licensemanagerusersubscriptions.model.ListIdentityProvidersResponse.ReadOnly
      ]
  object StartProductSubscription
      extends Effect[
        StartProductSubscriptionRequest,
        AwsError,
        zio.aws.licensemanagerusersubscriptions.model.StartProductSubscriptionResponse.ReadOnly
      ]
  object AssociateUser
      extends Effect[
        AssociateUserRequest,
        AwsError,
        zio.aws.licensemanagerusersubscriptions.model.AssociateUserResponse.ReadOnly
      ]
  object DeregisterIdentityProvider
      extends Effect[
        DeregisterIdentityProviderRequest,
        AwsError,
        zio.aws.licensemanagerusersubscriptions.model.DeregisterIdentityProviderResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, LicenseManagerUserSubscriptions] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, LicenseManagerUserSubscriptions] { rts =>
        zio.ZIO.succeed {
          new LicenseManagerUserSubscriptions {
            val api: LicenseManagerUserSubscriptionsAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): LicenseManagerUserSubscriptions = this
            def stopProductSubscription(
                request: StopProductSubscriptionRequest
            ): IO[
              AwsError,
              zio.aws.licensemanagerusersubscriptions.model.StopProductSubscriptionResponse.ReadOnly
            ] = proxy(StopProductSubscription, request)
            def disassociateUser(request: DisassociateUserRequest): IO[
              AwsError,
              zio.aws.licensemanagerusersubscriptions.model.DisassociateUserResponse.ReadOnly
            ] = proxy(DisassociateUser, request)
            def listProductSubscriptions(
                request: ListProductSubscriptionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.licensemanagerusersubscriptions.model.ProductUserSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListProductSubscriptions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listProductSubscriptionsPaginated(
                request: ListProductSubscriptionsRequest
            ): IO[
              AwsError,
              zio.aws.licensemanagerusersubscriptions.model.ListProductSubscriptionsResponse.ReadOnly
            ] = proxy(ListProductSubscriptionsPaginated, request)
            def listInstances(
                request: ListInstancesRequest
            ): ZStream[Any, AwsError, ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListInstances, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listInstancesPaginated(request: ListInstancesRequest): IO[
              AwsError,
              zio.aws.licensemanagerusersubscriptions.model.ListInstancesResponse.ReadOnly
            ] = proxy(ListInstancesPaginated, request)
            def registerIdentityProvider(
                request: RegisterIdentityProviderRequest
            ): IO[
              AwsError,
              zio.aws.licensemanagerusersubscriptions.model.RegisterIdentityProviderResponse.ReadOnly
            ] = proxy(RegisterIdentityProvider, request)
            def listUserAssociations(
                request: ListUserAssociationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.licensemanagerusersubscriptions.model.InstanceUserSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListUserAssociations, request)
                }
                .getOrThrowFiberFailure()
            }
            def listUserAssociationsPaginated(
                request: ListUserAssociationsRequest
            ): IO[
              AwsError,
              zio.aws.licensemanagerusersubscriptions.model.ListUserAssociationsResponse.ReadOnly
            ] = proxy(ListUserAssociationsPaginated, request)
            def listIdentityProviders(
                request: ListIdentityProvidersRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.licensemanagerusersubscriptions.model.IdentityProviderSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListIdentityProviders, request)
                }
                .getOrThrowFiberFailure()
            }
            def listIdentityProvidersPaginated(
                request: ListIdentityProvidersRequest
            ): IO[
              AwsError,
              zio.aws.licensemanagerusersubscriptions.model.ListIdentityProvidersResponse.ReadOnly
            ] = proxy(ListIdentityProvidersPaginated, request)
            def startProductSubscription(
                request: StartProductSubscriptionRequest
            ): IO[
              AwsError,
              zio.aws.licensemanagerusersubscriptions.model.StartProductSubscriptionResponse.ReadOnly
            ] = proxy(StartProductSubscription, request)
            def associateUser(request: AssociateUserRequest): IO[
              AwsError,
              zio.aws.licensemanagerusersubscriptions.model.AssociateUserResponse.ReadOnly
            ] = proxy(AssociateUser, request)
            def deregisterIdentityProvider(
                request: DeregisterIdentityProviderRequest
            ): IO[
              AwsError,
              zio.aws.licensemanagerusersubscriptions.model.DeregisterIdentityProviderResponse.ReadOnly
            ] = proxy(DeregisterIdentityProvider, request)
          }
        }
      }
    }
  }
}
