package zio.aws.licensemanagerusersubscriptions.model
import zio.aws.licensemanagerusersubscriptions.model.primitives.BoxInteger
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListProductSubscriptionsRequest(
    filters: Optional[
      Iterable[zio.aws.licensemanagerusersubscriptions.model.Filter]
    ] = Optional.Absent,
    identityProvider: zio.aws.licensemanagerusersubscriptions.model.IdentityProvider,
    maxResults: Optional[BoxInteger] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    product: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListProductSubscriptionsRequest = {
    import ListProductSubscriptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListProductSubscriptionsRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .identityProvider(identityProvider.buildAwsValue())
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .product(product: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.licensemanagerusersubscriptions.model.ListProductSubscriptionsRequest.ReadOnly =
    zio.aws.licensemanagerusersubscriptions.model.ListProductSubscriptionsRequest
      .wrap(buildAwsValue())
}
object ListProductSubscriptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListProductSubscriptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.licensemanagerusersubscriptions.model.ListProductSubscriptionsRequest =
      zio.aws.licensemanagerusersubscriptions.model
        .ListProductSubscriptionsRequest(
          filters.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          identityProvider.asEditable,
          maxResults.map(value => value),
          nextToken.map(value => value),
          product
        )
    def filters: Optional[
      List[zio.aws.licensemanagerusersubscriptions.model.Filter.ReadOnly]
    ]
    def identityProvider
        : zio.aws.licensemanagerusersubscriptions.model.IdentityProvider.ReadOnly
    def maxResults: Optional[BoxInteger]
    def nextToken: Optional[String]
    def product: String
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.licensemanagerusersubscriptions.model.Filter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getIdentityProvider: ZIO[
      Any,
      Nothing,
      zio.aws.licensemanagerusersubscriptions.model.IdentityProvider.ReadOnly
    ] = ZIO.succeed(identityProvider)
    def getMaxResults: ZIO[Any, AwsError, BoxInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getProduct: ZIO[Any, Nothing, String] = ZIO.succeed(product)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListProductSubscriptionsRequest
  ) extends zio.aws.licensemanagerusersubscriptions.model.ListProductSubscriptionsRequest.ReadOnly {
    override val filters: Optional[
      List[zio.aws.licensemanagerusersubscriptions.model.Filter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.licensemanagerusersubscriptions.model.Filter.wrap(item)
        }.toList
      )
    override val identityProvider
        : zio.aws.licensemanagerusersubscriptions.model.IdentityProvider.ReadOnly =
      zio.aws.licensemanagerusersubscriptions.model.IdentityProvider
        .wrap(impl.identityProvider())
    override val maxResults: Optional[BoxInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: BoxInteger)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val product: String = impl.product(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListProductSubscriptionsRequest
  ): zio.aws.licensemanagerusersubscriptions.model.ListProductSubscriptionsRequest.ReadOnly =
    new Wrapper(impl)
}
