package zio.aws.licensemanagerusersubscriptions.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RegisterIdentityProviderRequest(
    identityProvider: zio.aws.licensemanagerusersubscriptions.model.IdentityProvider,
    product: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanagerusersubscriptions.model.RegisterIdentityProviderRequest = {
    import RegisterIdentityProviderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanagerusersubscriptions.model.RegisterIdentityProviderRequest
      .builder()
      .identityProvider(identityProvider.buildAwsValue())
      .product(product: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.licensemanagerusersubscriptions.model.RegisterIdentityProviderRequest.ReadOnly =
    zio.aws.licensemanagerusersubscriptions.model.RegisterIdentityProviderRequest
      .wrap(buildAwsValue())
}
object RegisterIdentityProviderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanagerusersubscriptions.model.RegisterIdentityProviderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.licensemanagerusersubscriptions.model.RegisterIdentityProviderRequest =
      zio.aws.licensemanagerusersubscriptions.model
        .RegisterIdentityProviderRequest(identityProvider.asEditable, product)
    def identityProvider
        : zio.aws.licensemanagerusersubscriptions.model.IdentityProvider.ReadOnly
    def product: String
    def getIdentityProvider: ZIO[
      Any,
      Nothing,
      zio.aws.licensemanagerusersubscriptions.model.IdentityProvider.ReadOnly
    ] = ZIO.succeed(identityProvider)
    def getProduct: ZIO[Any, Nothing, String] = ZIO.succeed(product)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.licensemanagerusersubscriptions.model.RegisterIdentityProviderRequest
  ) extends zio.aws.licensemanagerusersubscriptions.model.RegisterIdentityProviderRequest.ReadOnly {
    override val identityProvider
        : zio.aws.licensemanagerusersubscriptions.model.IdentityProvider.ReadOnly =
      zio.aws.licensemanagerusersubscriptions.model.IdentityProvider
        .wrap(impl.identityProvider())
    override val product: String = impl.product(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanagerusersubscriptions.model.RegisterIdentityProviderRequest
  ): zio.aws.licensemanagerusersubscriptions.model.RegisterIdentityProviderRequest.ReadOnly =
    new Wrapper(impl)
}
