package zio.aws.licensemanagerlinuxsubscriptions
import zio.mock.{Proxy, Mock}
import zio.aws.licensemanagerlinuxsubscriptions.model.{
  UpdateServiceSettingsRequest,
  ListLinuxSubscriptionsRequest,
  ListLinuxSubscriptionInstancesRequest,
  GetServiceSettingsRequest
}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.licensemanagerlinuxsubscriptions.model.Subscription.ReadOnly
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.LicenseManagerLinuxSubscriptionsAsyncClient
import zio.stream.ZStream
object LicenseManagerLinuxSubscriptionsMock
    extends Mock[LicenseManagerLinuxSubscriptions] {
  object GetServiceSettings
      extends Effect[
        GetServiceSettingsRequest,
        AwsError,
        zio.aws.licensemanagerlinuxsubscriptions.model.GetServiceSettingsResponse.ReadOnly
      ]
  object ListLinuxSubscriptionInstances
      extends Stream[
        ListLinuxSubscriptionInstancesRequest,
        AwsError,
        zio.aws.licensemanagerlinuxsubscriptions.model.Instance.ReadOnly
      ]
  object ListLinuxSubscriptionInstancesPaginated
      extends Effect[
        ListLinuxSubscriptionInstancesRequest,
        AwsError,
        zio.aws.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionInstancesResponse.ReadOnly
      ]
  object ListLinuxSubscriptions
      extends Stream[ListLinuxSubscriptionsRequest, AwsError, ReadOnly]
  object ListLinuxSubscriptionsPaginated
      extends Effect[
        ListLinuxSubscriptionsRequest,
        AwsError,
        zio.aws.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionsResponse.ReadOnly
      ]
  object UpdateServiceSettings
      extends Effect[
        UpdateServiceSettingsRequest,
        AwsError,
        zio.aws.licensemanagerlinuxsubscriptions.model.UpdateServiceSettingsResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, LicenseManagerLinuxSubscriptions] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, LicenseManagerLinuxSubscriptions] { rts =>
        zio.ZIO.succeed {
          new LicenseManagerLinuxSubscriptions {
            val api: LicenseManagerLinuxSubscriptionsAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): LicenseManagerLinuxSubscriptions = this
            def getServiceSettings(request: GetServiceSettingsRequest): IO[
              AwsError,
              zio.aws.licensemanagerlinuxsubscriptions.model.GetServiceSettingsResponse.ReadOnly
            ] = proxy(GetServiceSettings, request)
            def listLinuxSubscriptionInstances(
                request: ListLinuxSubscriptionInstancesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.licensemanagerlinuxsubscriptions.model.Instance.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListLinuxSubscriptionInstances, request)
                }
                .getOrThrowFiberFailure()
            }
            def listLinuxSubscriptionInstancesPaginated(
                request: ListLinuxSubscriptionInstancesRequest
            ): IO[
              AwsError,
              zio.aws.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionInstancesResponse.ReadOnly
            ] = proxy(ListLinuxSubscriptionInstancesPaginated, request)
            def listLinuxSubscriptions(
                request: ListLinuxSubscriptionsRequest
            ): ZStream[Any, AwsError, ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListLinuxSubscriptions, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listLinuxSubscriptionsPaginated(
                request: ListLinuxSubscriptionsRequest
            ): IO[
              AwsError,
              zio.aws.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionsResponse.ReadOnly
            ] = proxy(ListLinuxSubscriptionsPaginated, request)
            def updateServiceSettings(
                request: UpdateServiceSettingsRequest
            ): IO[
              AwsError,
              zio.aws.licensemanagerlinuxsubscriptions.model.UpdateServiceSettingsResponse.ReadOnly
            ] = proxy(UpdateServiceSettings, request)
          }
        }
      }
    }
  }
}
