package zio.aws.licensemanagerlinuxsubscriptions.model
import scala.jdk.CollectionConverters._
sealed trait OrganizationIntegration {
  def unwrap
      : software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.OrganizationIntegration
}
object OrganizationIntegration {
  def wrap(
      value: software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.OrganizationIntegration
  ): zio.aws.licensemanagerlinuxsubscriptions.model.OrganizationIntegration =
    value match {
      case software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.OrganizationIntegration.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.OrganizationIntegration.ENABLED =>
        val r = Enabled
        r
      case software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.OrganizationIntegration.DISABLED =>
        val r = Disabled
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.licensemanagerlinuxsubscriptions.model.OrganizationIntegration {
    override def unwrap
        : software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.OrganizationIntegration =
      software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.OrganizationIntegration.UNKNOWN_TO_SDK_VERSION
  }
  case object Enabled
      extends zio.aws.licensemanagerlinuxsubscriptions.model.OrganizationIntegration {
    override def unwrap
        : software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.OrganizationIntegration =
      software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.OrganizationIntegration.ENABLED
  }
  case object Disabled
      extends zio.aws.licensemanagerlinuxsubscriptions.model.OrganizationIntegration {
    override def unwrap
        : software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.OrganizationIntegration =
      software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.OrganizationIntegration.DISABLED
  }
}
