package zio.aws.licensemanagerlinuxsubscriptions.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.licensemanagerlinuxsubscriptions.model.primitives.{
  ListLinuxSubscriptionsRequestNextTokenString,
  BoxInteger
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListLinuxSubscriptionsRequest(
    filters: Optional[
      Iterable[zio.aws.licensemanagerlinuxsubscriptions.model.Filter]
    ] = Optional.Absent,
    maxResults: Optional[BoxInteger] = Optional.Absent,
    nextToken: Optional[ListLinuxSubscriptionsRequestNextTokenString] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionsRequest = {
    import ListLinuxSubscriptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionsRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(
        nextToken.map(value =>
          ListLinuxSubscriptionsRequestNextTokenString.unwrap(
            value
          ): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionsRequest.ReadOnly =
    zio.aws.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionsRequest
      .wrap(buildAwsValue())
}
object ListLinuxSubscriptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionsRequest =
      zio.aws.licensemanagerlinuxsubscriptions.model
        .ListLinuxSubscriptionsRequest(
          filters.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          maxResults.map(value => value),
          nextToken.map(value => value)
        )
    def filters: Optional[
      List[zio.aws.licensemanagerlinuxsubscriptions.model.Filter.ReadOnly]
    ]
    def maxResults: Optional[BoxInteger]
    def nextToken: Optional[ListLinuxSubscriptionsRequestNextTokenString]
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.licensemanagerlinuxsubscriptions.model.Filter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, BoxInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken
        : ZIO[Any, AwsError, ListLinuxSubscriptionsRequestNextTokenString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionsRequest
  ) extends zio.aws.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionsRequest.ReadOnly {
    override val filters: Optional[
      List[zio.aws.licensemanagerlinuxsubscriptions.model.Filter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.licensemanagerlinuxsubscriptions.model.Filter.wrap(item)
        }.toList
      )
    override val maxResults: Optional[BoxInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: BoxInteger)
    override val nextToken
        : Optional[ListLinuxSubscriptionsRequestNextTokenString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.licensemanagerlinuxsubscriptions.model.primitives
            .ListLinuxSubscriptionsRequestNextTokenString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionsRequest
  ): zio.aws.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionsRequest.ReadOnly =
    new Wrapper(impl)
}
