package zio.aws.licensemanagerlinuxsubscriptions.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListLinuxSubscriptionInstancesResponse(
    instances: Optional[
      Iterable[zio.aws.licensemanagerlinuxsubscriptions.model.Instance]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionInstancesResponse = {
    import ListLinuxSubscriptionInstancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionInstancesResponse
      .builder()
      .optionallyWith(
        instances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instances)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionInstancesResponse.ReadOnly =
    zio.aws.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionInstancesResponse
      .wrap(buildAwsValue())
}
object ListLinuxSubscriptionInstancesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionInstancesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionInstancesResponse =
      zio.aws.licensemanagerlinuxsubscriptions.model
        .ListLinuxSubscriptionInstancesResponse(
          instances.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          nextToken.map(value => value)
        )
    def instances: Optional[
      List[zio.aws.licensemanagerlinuxsubscriptions.model.Instance.ReadOnly]
    ]
    def nextToken: Optional[String]
    def getInstances: ZIO[Any, AwsError, List[
      zio.aws.licensemanagerlinuxsubscriptions.model.Instance.ReadOnly
    ]] = AwsError.unwrapOptionField("instances", instances)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionInstancesResponse
  ) extends zio.aws.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionInstancesResponse.ReadOnly {
    override val instances: Optional[
      List[zio.aws.licensemanagerlinuxsubscriptions.model.Instance.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.instances())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.licensemanagerlinuxsubscriptions.model.Instance.wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionInstancesResponse
  ): zio.aws.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionInstancesResponse.ReadOnly =
    new Wrapper(impl)
}
