package zio.aws.licensemanagerlinuxsubscriptions
import zio.aws.core.config.AwsConfig
import zio.aws.licensemanagerlinuxsubscriptions.model.{
  UpdateServiceSettingsRequest,
  ListLinuxSubscriptionsRequest,
  ListLinuxSubscriptionInstancesRequest,
  GetServiceSettingsRequest
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.aws.licensemanagerlinuxsubscriptions.model.Subscription.ReadOnly
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.{
  LicenseManagerLinuxSubscriptionsAsyncClientBuilder,
  LicenseManagerLinuxSubscriptionsAsyncClient
}
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.{
  Instance,
  Subscription,
  ListLinuxSubscriptionInstancesResponse,
  ListLinuxSubscriptionsResponse,
  UpdateServiceSettingsResponse,
  GetServiceSettingsResponse
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait LicenseManagerLinuxSubscriptions
    extends AspectSupport[LicenseManagerLinuxSubscriptions] {
  val api: LicenseManagerLinuxSubscriptionsAsyncClient
  def getServiceSettings(request: GetServiceSettingsRequest): IO[
    AwsError,
    zio.aws.licensemanagerlinuxsubscriptions.model.GetServiceSettingsResponse.ReadOnly
  ]
  def listLinuxSubscriptionInstances(
      request: ListLinuxSubscriptionInstancesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.licensemanagerlinuxsubscriptions.model.Instance.ReadOnly
  ]
  def listLinuxSubscriptionInstancesPaginated(
      request: ListLinuxSubscriptionInstancesRequest
  ): IO[
    AwsError,
    zio.aws.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionInstancesResponse.ReadOnly
  ]
  def listLinuxSubscriptions(
      request: ListLinuxSubscriptionsRequest
  ): ZStream[Any, AwsError, ReadOnly]
  def listLinuxSubscriptionsPaginated(
      request: ListLinuxSubscriptionsRequest
  ): IO[
    AwsError,
    zio.aws.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionsResponse.ReadOnly
  ]
  def updateServiceSettings(request: UpdateServiceSettingsRequest): IO[
    AwsError,
    zio.aws.licensemanagerlinuxsubscriptions.model.UpdateServiceSettingsResponse.ReadOnly
  ]
}
object LicenseManagerLinuxSubscriptions {
  val live: ZLayer[
    AwsConfig,
    java.lang.Throwable,
    LicenseManagerLinuxSubscriptions
  ] = customized(identity)
  def customized(
      customization: LicenseManagerLinuxSubscriptionsAsyncClientBuilder => LicenseManagerLinuxSubscriptionsAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, LicenseManagerLinuxSubscriptions] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: LicenseManagerLinuxSubscriptionsAsyncClientBuilder => LicenseManagerLinuxSubscriptionsAsyncClientBuilder
  ): ZIO[
    AwsConfig with Scope,
    java.lang.Throwable,
    LicenseManagerLinuxSubscriptions
  ] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = LicenseManagerLinuxSubscriptionsAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[
      LicenseManagerLinuxSubscriptionsAsyncClient,
      LicenseManagerLinuxSubscriptionsAsyncClientBuilder
    ](builder);
    b1 <- awsConfig.configureHttpClient[
      LicenseManagerLinuxSubscriptionsAsyncClient,
      LicenseManagerLinuxSubscriptionsAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new LicenseManagerLinuxSubscriptionsImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class LicenseManagerLinuxSubscriptionsImpl[R](
      override val api: LicenseManagerLinuxSubscriptionsAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends LicenseManagerLinuxSubscriptions
      with AwsServiceBase[R] {
    override val serviceName: String = "LicenseManagerLinuxSubscriptions"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): LicenseManagerLinuxSubscriptionsImpl[R1] =
      new LicenseManagerLinuxSubscriptionsImpl(api, newAspect, r)
    def getServiceSettings(request: GetServiceSettingsRequest): IO[
      AwsError,
      zio.aws.licensemanagerlinuxsubscriptions.model.GetServiceSettingsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.GetServiceSettingsRequest,
      GetServiceSettingsResponse
    ]("getServiceSettings", api.getServiceSettings)(request.buildAwsValue())
      .map(
        zio.aws.licensemanagerlinuxsubscriptions.model.GetServiceSettingsResponse.wrap
      )
      .provideEnvironment(r)
    def listLinuxSubscriptionInstances(
        request: ListLinuxSubscriptionInstancesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.licensemanagerlinuxsubscriptions.model.Instance.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionInstancesRequest,
      ListLinuxSubscriptionInstancesResponse,
      Instance
    ](
      "listLinuxSubscriptionInstances",
      api.listLinuxSubscriptionInstances,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.instances().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.licensemanagerlinuxsubscriptions.model.Instance.wrap(item)
      )
      .provideEnvironment(r)
    def listLinuxSubscriptionInstancesPaginated(
        request: ListLinuxSubscriptionInstancesRequest
    ): IO[
      AwsError,
      zio.aws.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionInstancesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionInstancesRequest,
      ListLinuxSubscriptionInstancesResponse
    ]("listLinuxSubscriptionInstances", api.listLinuxSubscriptionInstances)(
      request.buildAwsValue()
    ).map(
      zio.aws.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionInstancesResponse.wrap
    ).provideEnvironment(r)
    def listLinuxSubscriptions(
        request: ListLinuxSubscriptionsRequest
    ): ZStream[Any, AwsError, ReadOnly] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionsRequest,
      ListLinuxSubscriptionsResponse,
      Subscription
    ](
      "listLinuxSubscriptions",
      api.listLinuxSubscriptions,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.subscriptions().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.licensemanagerlinuxsubscriptions.model.Subscription.wrap(item)
      )
      .provideEnvironment(r)
    def listLinuxSubscriptionsPaginated(
        request: ListLinuxSubscriptionsRequest
    ): IO[
      AwsError,
      zio.aws.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionsRequest,
      ListLinuxSubscriptionsResponse
    ]("listLinuxSubscriptions", api.listLinuxSubscriptions)(
      request.buildAwsValue()
    ).map(
      zio.aws.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionsResponse.wrap
    ).provideEnvironment(r)
    def updateServiceSettings(request: UpdateServiceSettingsRequest): IO[
      AwsError,
      zio.aws.licensemanagerlinuxsubscriptions.model.UpdateServiceSettingsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.UpdateServiceSettingsRequest,
      UpdateServiceSettingsResponse
    ]("updateServiceSettings", api.updateServiceSettings)(
      request.buildAwsValue()
    ).map(
      zio.aws.licensemanagerlinuxsubscriptions.model.UpdateServiceSettingsResponse.wrap
    ).provideEnvironment(r)
  }
  def getServiceSettings(request: GetServiceSettingsRequest): ZIO[
    zio.aws.licensemanagerlinuxsubscriptions.LicenseManagerLinuxSubscriptions,
    AwsError,
    zio.aws.licensemanagerlinuxsubscriptions.model.GetServiceSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getServiceSettings(request))
  def listLinuxSubscriptionInstances(
      request: ListLinuxSubscriptionInstancesRequest
  ): ZStream[
    zio.aws.licensemanagerlinuxsubscriptions.LicenseManagerLinuxSubscriptions,
    AwsError,
    zio.aws.licensemanagerlinuxsubscriptions.model.Instance.ReadOnly
  ] = ZStream.serviceWithStream(_.listLinuxSubscriptionInstances(request))
  def listLinuxSubscriptionInstancesPaginated(
      request: ListLinuxSubscriptionInstancesRequest
  ): ZIO[
    zio.aws.licensemanagerlinuxsubscriptions.LicenseManagerLinuxSubscriptions,
    AwsError,
    zio.aws.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionInstancesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listLinuxSubscriptionInstancesPaginated(request))
  def listLinuxSubscriptions(request: ListLinuxSubscriptionsRequest): ZStream[
    zio.aws.licensemanagerlinuxsubscriptions.LicenseManagerLinuxSubscriptions,
    AwsError,
    ReadOnly
  ] = ZStream.serviceWithStream(_.listLinuxSubscriptions(request))
  def listLinuxSubscriptionsPaginated(
      request: ListLinuxSubscriptionsRequest
  ): ZIO[
    zio.aws.licensemanagerlinuxsubscriptions.LicenseManagerLinuxSubscriptions,
    AwsError,
    zio.aws.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listLinuxSubscriptionsPaginated(request))
  def updateServiceSettings(request: UpdateServiceSettingsRequest): ZIO[
    zio.aws.licensemanagerlinuxsubscriptions.LicenseManagerLinuxSubscriptions,
    AwsError,
    zio.aws.licensemanagerlinuxsubscriptions.model.UpdateServiceSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateServiceSettings(request))
}
