package zio.aws.licensemanagerlinuxsubscriptions.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListLinuxSubscriptionsResponse(
    nextToken: Optional[String] = Optional.Absent,
    subscriptions: Optional[
      Iterable[zio.aws.licensemanagerlinuxsubscriptions.model.Subscription]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionsResponse = {
    import ListLinuxSubscriptionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        subscriptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.subscriptions)
      .build()
  }
  def asReadOnly
      : zio.aws.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionsResponse.ReadOnly =
    zio.aws.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionsResponse
      .wrap(buildAwsValue())
}
object ListLinuxSubscriptionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionsResponse =
      zio.aws.licensemanagerlinuxsubscriptions.model
        .ListLinuxSubscriptionsResponse(
          nextToken.map(value => value),
          subscriptions.map(value =>
            value.map { item =>
              item.asEditable
            }
          )
        )
    def nextToken: Optional[String]
    def subscriptions: Optional[
      List[zio.aws.licensemanagerlinuxsubscriptions.model.Subscription.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSubscriptions: ZIO[Any, AwsError, List[
      zio.aws.licensemanagerlinuxsubscriptions.model.Subscription.ReadOnly
    ]] = AwsError.unwrapOptionField("subscriptions", subscriptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionsResponse
  ) extends zio.aws.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionsResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val subscriptions: Optional[
      List[zio.aws.licensemanagerlinuxsubscriptions.model.Subscription.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.subscriptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.licensemanagerlinuxsubscriptions.model.Subscription.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionsResponse
  ): zio.aws.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionsResponse.ReadOnly =
    new Wrapper(impl)
}
