package zio.aws.licensemanagerlinuxsubscriptions.model
import zio.aws.licensemanagerlinuxsubscriptions.model.primitives.StringListMemberString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateServiceSettingsResponse(
    homeRegions: Optional[Iterable[StringListMemberString]] = Optional.Absent,
    linuxSubscriptionsDiscovery: Optional[
      zio.aws.licensemanagerlinuxsubscriptions.model.LinuxSubscriptionsDiscovery
    ] = Optional.Absent,
    linuxSubscriptionsDiscoverySettings: Optional[
      zio.aws.licensemanagerlinuxsubscriptions.model.LinuxSubscriptionsDiscoverySettings
    ] = Optional.Absent,
    status: Optional[zio.aws.licensemanagerlinuxsubscriptions.model.Status] =
      Optional.Absent,
    statusMessage: Optional[Map[String, String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.UpdateServiceSettingsResponse = {
    import UpdateServiceSettingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.UpdateServiceSettingsResponse
      .builder()
      .optionallyWith(
        homeRegions.map(value =>
          value.map { item =>
            StringListMemberString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.homeRegions)
      .optionallyWith(linuxSubscriptionsDiscovery.map(value => value.unwrap))(
        _.linuxSubscriptionsDiscovery
      )
      .optionallyWith(
        linuxSubscriptionsDiscoverySettings.map(value => value.buildAwsValue())
      )(_.linuxSubscriptionsDiscoverySettings)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusMessage.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.statusMessage)
      .build()
  }
  def asReadOnly
      : zio.aws.licensemanagerlinuxsubscriptions.model.UpdateServiceSettingsResponse.ReadOnly =
    zio.aws.licensemanagerlinuxsubscriptions.model.UpdateServiceSettingsResponse
      .wrap(buildAwsValue())
}
object UpdateServiceSettingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.UpdateServiceSettingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.licensemanagerlinuxsubscriptions.model.UpdateServiceSettingsResponse =
      zio.aws.licensemanagerlinuxsubscriptions.model
        .UpdateServiceSettingsResponse(
          homeRegions.map(value => value),
          linuxSubscriptionsDiscovery.map(value => value),
          linuxSubscriptionsDiscoverySettings.map(value => value.asEditable),
          status.map(value => value),
          statusMessage.map(value => value)
        )
    def homeRegions: Optional[List[StringListMemberString]]
    def linuxSubscriptionsDiscovery: Optional[
      zio.aws.licensemanagerlinuxsubscriptions.model.LinuxSubscriptionsDiscovery
    ]
    def linuxSubscriptionsDiscoverySettings: Optional[
      zio.aws.licensemanagerlinuxsubscriptions.model.LinuxSubscriptionsDiscoverySettings.ReadOnly
    ]
    def status: Optional[zio.aws.licensemanagerlinuxsubscriptions.model.Status]
    def statusMessage: Optional[Map[String, String]]
    def getHomeRegions: ZIO[Any, AwsError, List[StringListMemberString]] =
      AwsError.unwrapOptionField("homeRegions", homeRegions)
    def getLinuxSubscriptionsDiscovery: ZIO[
      Any,
      AwsError,
      zio.aws.licensemanagerlinuxsubscriptions.model.LinuxSubscriptionsDiscovery
    ] = AwsError.unwrapOptionField(
      "linuxSubscriptionsDiscovery",
      linuxSubscriptionsDiscovery
    )
    def getLinuxSubscriptionsDiscoverySettings: ZIO[
      Any,
      AwsError,
      zio.aws.licensemanagerlinuxsubscriptions.model.LinuxSubscriptionsDiscoverySettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "linuxSubscriptionsDiscoverySettings",
      linuxSubscriptionsDiscoverySettings
    )
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.licensemanagerlinuxsubscriptions.model.Status
    ] = AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.UpdateServiceSettingsResponse
  ) extends zio.aws.licensemanagerlinuxsubscriptions.model.UpdateServiceSettingsResponse.ReadOnly {
    override val homeRegions: Optional[List[StringListMemberString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.homeRegions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.licensemanagerlinuxsubscriptions.model.primitives
              .StringListMemberString(item)
          }.toList
        )
    override val linuxSubscriptionsDiscovery: Optional[
      zio.aws.licensemanagerlinuxsubscriptions.model.LinuxSubscriptionsDiscovery
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.linuxSubscriptionsDiscovery())
      .map(value =>
        zio.aws.licensemanagerlinuxsubscriptions.model.LinuxSubscriptionsDiscovery
          .wrap(value)
      )
    override val linuxSubscriptionsDiscoverySettings: Optional[
      zio.aws.licensemanagerlinuxsubscriptions.model.LinuxSubscriptionsDiscoverySettings.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.linuxSubscriptionsDiscoverySettings())
      .map(value =>
        zio.aws.licensemanagerlinuxsubscriptions.model.LinuxSubscriptionsDiscoverySettings
          .wrap(value)
      )
    override val status
        : Optional[zio.aws.licensemanagerlinuxsubscriptions.model.Status] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.licensemanagerlinuxsubscriptions.model.Status.wrap(value)
        )
    override val statusMessage: Optional[Map[String, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusMessage())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: String)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.UpdateServiceSettingsResponse
  ): zio.aws.licensemanagerlinuxsubscriptions.model.UpdateServiceSettingsResponse.ReadOnly =
    new Wrapper(impl)
}
