package zio.aws.licensemanagerlinuxsubscriptions.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateServiceSettingsRequest(
    allowUpdate: Optional[Boolean] = Optional.Absent,
    linuxSubscriptionsDiscovery: zio.aws.licensemanagerlinuxsubscriptions.model.LinuxSubscriptionsDiscovery,
    linuxSubscriptionsDiscoverySettings: zio.aws.licensemanagerlinuxsubscriptions.model.LinuxSubscriptionsDiscoverySettings
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.UpdateServiceSettingsRequest = {
    import UpdateServiceSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.UpdateServiceSettingsRequest
      .builder()
      .optionallyWith(allowUpdate.map(value => value: java.lang.Boolean))(
        _.allowUpdate
      )
      .linuxSubscriptionsDiscovery(linuxSubscriptionsDiscovery.unwrap)
      .linuxSubscriptionsDiscoverySettings(
        linuxSubscriptionsDiscoverySettings.buildAwsValue()
      )
      .build()
  }
  def asReadOnly
      : zio.aws.licensemanagerlinuxsubscriptions.model.UpdateServiceSettingsRequest.ReadOnly =
    zio.aws.licensemanagerlinuxsubscriptions.model.UpdateServiceSettingsRequest
      .wrap(buildAwsValue())
}
object UpdateServiceSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.UpdateServiceSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.licensemanagerlinuxsubscriptions.model.UpdateServiceSettingsRequest =
      zio.aws.licensemanagerlinuxsubscriptions.model
        .UpdateServiceSettingsRequest(
          allowUpdate.map(value => value),
          linuxSubscriptionsDiscovery,
          linuxSubscriptionsDiscoverySettings.asEditable
        )
    def allowUpdate: Optional[Boolean]
    def linuxSubscriptionsDiscovery
        : zio.aws.licensemanagerlinuxsubscriptions.model.LinuxSubscriptionsDiscovery
    def linuxSubscriptionsDiscoverySettings
        : zio.aws.licensemanagerlinuxsubscriptions.model.LinuxSubscriptionsDiscoverySettings.ReadOnly
    def getAllowUpdate: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("allowUpdate", allowUpdate)
    def getLinuxSubscriptionsDiscovery: ZIO[
      Any,
      Nothing,
      zio.aws.licensemanagerlinuxsubscriptions.model.LinuxSubscriptionsDiscovery
    ] = ZIO.succeed(linuxSubscriptionsDiscovery)
    def getLinuxSubscriptionsDiscoverySettings: ZIO[
      Any,
      Nothing,
      zio.aws.licensemanagerlinuxsubscriptions.model.LinuxSubscriptionsDiscoverySettings.ReadOnly
    ] = ZIO.succeed(linuxSubscriptionsDiscoverySettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.UpdateServiceSettingsRequest
  ) extends zio.aws.licensemanagerlinuxsubscriptions.model.UpdateServiceSettingsRequest.ReadOnly {
    override val allowUpdate: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.allowUpdate())
      .map(value => value: Boolean)
    override val linuxSubscriptionsDiscovery
        : zio.aws.licensemanagerlinuxsubscriptions.model.LinuxSubscriptionsDiscovery =
      zio.aws.licensemanagerlinuxsubscriptions.model.LinuxSubscriptionsDiscovery
        .wrap(impl.linuxSubscriptionsDiscovery())
    override val linuxSubscriptionsDiscoverySettings
        : zio.aws.licensemanagerlinuxsubscriptions.model.LinuxSubscriptionsDiscoverySettings.ReadOnly =
      zio.aws.licensemanagerlinuxsubscriptions.model.LinuxSubscriptionsDiscoverySettings
        .wrap(impl.linuxSubscriptionsDiscoverySettings())
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.UpdateServiceSettingsRequest
  ): zio.aws.licensemanagerlinuxsubscriptions.model.UpdateServiceSettingsRequest.ReadOnly =
    new Wrapper(impl)
}
