package zio.aws.licensemanagerlinuxsubscriptions.model
import zio.aws.licensemanagerlinuxsubscriptions.model.primitives.BoxLong
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Subscription(
    instanceCount: Optional[BoxLong] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    `type`: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.Subscription = {
    import Subscription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.Subscription
      .builder()
      .optionallyWith(instanceCount.map(value => value: java.lang.Long))(
        _.instanceCount
      )
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(`type`.map(value => value: java.lang.String))(_.`type`)
      .build()
  }
  def asReadOnly
      : zio.aws.licensemanagerlinuxsubscriptions.model.Subscription.ReadOnly =
    zio.aws.licensemanagerlinuxsubscriptions.model.Subscription
      .wrap(buildAwsValue())
}
object Subscription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.Subscription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.licensemanagerlinuxsubscriptions.model.Subscription =
      zio.aws.licensemanagerlinuxsubscriptions.model.Subscription(
        instanceCount.map(value => value),
        name.map(value => value),
        `type`.map(value => value)
      )
    def instanceCount: Optional[BoxLong]
    def name: Optional[String]
    def `type`: Optional[String]
    def getInstanceCount: ZIO[Any, AwsError, BoxLong] =
      AwsError.unwrapOptionField("instanceCount", instanceCount)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.Subscription
  ) extends zio.aws.licensemanagerlinuxsubscriptions.model.Subscription.ReadOnly {
    override val instanceCount: Optional[BoxLong] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceCount())
      .map(value => value: BoxLong)
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val `type`: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.Subscription
  ): zio.aws.licensemanagerlinuxsubscriptions.model.Subscription.ReadOnly =
    new Wrapper(impl)
}
