package zio.aws.licensemanagerlinuxsubscriptions.model
import zio.aws.licensemanagerlinuxsubscriptions.model.primitives.StringListMemberString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class LinuxSubscriptionsDiscoverySettings(
    organizationIntegration: zio.aws.licensemanagerlinuxsubscriptions.model.OrganizationIntegration,
    sourceRegions: Iterable[StringListMemberString]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.LinuxSubscriptionsDiscoverySettings = {
    import LinuxSubscriptionsDiscoverySettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.LinuxSubscriptionsDiscoverySettings
      .builder()
      .organizationIntegration(organizationIntegration.unwrap)
      .sourceRegions(sourceRegions.map { item =>
        StringListMemberString.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.licensemanagerlinuxsubscriptions.model.LinuxSubscriptionsDiscoverySettings.ReadOnly =
    zio.aws.licensemanagerlinuxsubscriptions.model.LinuxSubscriptionsDiscoverySettings
      .wrap(buildAwsValue())
}
object LinuxSubscriptionsDiscoverySettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.LinuxSubscriptionsDiscoverySettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.licensemanagerlinuxsubscriptions.model.LinuxSubscriptionsDiscoverySettings =
      zio.aws.licensemanagerlinuxsubscriptions.model
        .LinuxSubscriptionsDiscoverySettings(
          organizationIntegration,
          sourceRegions
        )
    def organizationIntegration
        : zio.aws.licensemanagerlinuxsubscriptions.model.OrganizationIntegration
    def sourceRegions: List[StringListMemberString]
    def getOrganizationIntegration: ZIO[
      Any,
      Nothing,
      zio.aws.licensemanagerlinuxsubscriptions.model.OrganizationIntegration
    ] = ZIO.succeed(organizationIntegration)
    def getSourceRegions: ZIO[Any, Nothing, List[StringListMemberString]] =
      ZIO.succeed(sourceRegions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.LinuxSubscriptionsDiscoverySettings
  ) extends zio.aws.licensemanagerlinuxsubscriptions.model.LinuxSubscriptionsDiscoverySettings.ReadOnly {
    override val organizationIntegration
        : zio.aws.licensemanagerlinuxsubscriptions.model.OrganizationIntegration =
      zio.aws.licensemanagerlinuxsubscriptions.model.OrganizationIntegration
        .wrap(impl.organizationIntegration())
    override val sourceRegions: List[StringListMemberString] = impl
      .sourceRegions()
      .asScala
      .map { item =>
        zio.aws.licensemanagerlinuxsubscriptions.model.primitives
          .StringListMemberString(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.LinuxSubscriptionsDiscoverySettings
  ): zio.aws.licensemanagerlinuxsubscriptions.model.LinuxSubscriptionsDiscoverySettings.ReadOnly =
    new Wrapper(impl)
}
