package zio.aws.licensemanagerlinuxsubscriptions.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Instance(
    accountID: Optional[String] = Optional.Absent,
    amiId: Optional[String] = Optional.Absent,
    instanceID: Optional[String] = Optional.Absent,
    instanceType: Optional[String] = Optional.Absent,
    lastUpdatedTime: Optional[String] = Optional.Absent,
    productCode: Optional[Iterable[String]] = Optional.Absent,
    region: Optional[String] = Optional.Absent,
    status: Optional[String] = Optional.Absent,
    subscriptionName: Optional[String] = Optional.Absent,
    usageOperation: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.Instance = {
    import Instance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.Instance
      .builder()
      .optionallyWith(accountID.map(value => value: java.lang.String))(
        _.accountID
      )
      .optionallyWith(amiId.map(value => value: java.lang.String))(_.amiId)
      .optionallyWith(instanceID.map(value => value: java.lang.String))(
        _.instanceID
      )
      .optionallyWith(instanceType.map(value => value: java.lang.String))(
        _.instanceType
      )
      .optionallyWith(lastUpdatedTime.map(value => value: java.lang.String))(
        _.lastUpdatedTime
      )
      .optionallyWith(
        productCode.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.productCode)
      .optionallyWith(region.map(value => value: java.lang.String))(_.region)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(subscriptionName.map(value => value: java.lang.String))(
        _.subscriptionName
      )
      .optionallyWith(usageOperation.map(value => value: java.lang.String))(
        _.usageOperation
      )
      .build()
  }
  def asReadOnly
      : zio.aws.licensemanagerlinuxsubscriptions.model.Instance.ReadOnly =
    zio.aws.licensemanagerlinuxsubscriptions.model.Instance
      .wrap(buildAwsValue())
}
object Instance {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.Instance
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.licensemanagerlinuxsubscriptions.model.Instance =
      zio.aws.licensemanagerlinuxsubscriptions.model.Instance(
        accountID.map(value => value),
        amiId.map(value => value),
        instanceID.map(value => value),
        instanceType.map(value => value),
        lastUpdatedTime.map(value => value),
        productCode.map(value => value),
        region.map(value => value),
        status.map(value => value),
        subscriptionName.map(value => value),
        usageOperation.map(value => value)
      )
    def accountID: Optional[String]
    def amiId: Optional[String]
    def instanceID: Optional[String]
    def instanceType: Optional[String]
    def lastUpdatedTime: Optional[String]
    def productCode: Optional[List[String]]
    def region: Optional[String]
    def status: Optional[String]
    def subscriptionName: Optional[String]
    def usageOperation: Optional[String]
    def getAccountID: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("accountID", accountID)
    def getAmiId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("amiId", amiId)
    def getInstanceID: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceID", instanceID)
    def getInstanceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getLastUpdatedTime: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
    def getProductCode: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("productCode", productCode)
    def getRegion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("region", region)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getSubscriptionName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subscriptionName", subscriptionName)
    def getUsageOperation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("usageOperation", usageOperation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.Instance
  ) extends zio.aws.licensemanagerlinuxsubscriptions.model.Instance.ReadOnly {
    override val accountID: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.accountID())
      .map(value => value: String)
    override val amiId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.amiId())
      .map(value => value: String)
    override val instanceID: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceID())
      .map(value => value: String)
    override val instanceType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceType())
      .map(value => value: String)
    override val lastUpdatedTime: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedTime())
      .map(value => value: String)
    override val productCode: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.productCode())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val region: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.region())
      .map(value => value: String)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val subscriptionName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.subscriptionName())
      .map(value => value: String)
    override val usageOperation: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.usageOperation())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.Instance
  ): zio.aws.licensemanagerlinuxsubscriptions.model.Instance.ReadOnly =
    new Wrapper(impl)
}
