package zio.aws.licensemanagerlinuxsubscriptions.model
import zio.aws.licensemanagerlinuxsubscriptions.model.primitives.StringListMemberString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Filter(
    name: Optional[String] = Optional.Absent,
    operator: Optional[
      zio.aws.licensemanagerlinuxsubscriptions.model.Operator
    ] = Optional.Absent,
    values: Optional[Iterable[StringListMemberString]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.Filter = {
    import Filter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.Filter
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(operator.map(value => value.unwrap))(_.operator)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            StringListMemberString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly
      : zio.aws.licensemanagerlinuxsubscriptions.model.Filter.ReadOnly =
    zio.aws.licensemanagerlinuxsubscriptions.model.Filter.wrap(buildAwsValue())
}
object Filter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.Filter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.licensemanagerlinuxsubscriptions.model.Filter =
      zio.aws.licensemanagerlinuxsubscriptions.model.Filter(
        name.map(value => value),
        operator.map(value => value),
        values.map(value => value)
      )
    def name: Optional[String]
    def operator
        : Optional[zio.aws.licensemanagerlinuxsubscriptions.model.Operator]
    def values: Optional[List[StringListMemberString]]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getOperator: ZIO[
      Any,
      AwsError,
      zio.aws.licensemanagerlinuxsubscriptions.model.Operator
    ] = AwsError.unwrapOptionField("operator", operator)
    def getValues: ZIO[Any, AwsError, List[StringListMemberString]] =
      AwsError.unwrapOptionField("values", values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.Filter
  ) extends zio.aws.licensemanagerlinuxsubscriptions.model.Filter.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val operator
        : Optional[zio.aws.licensemanagerlinuxsubscriptions.model.Operator] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operator())
        .map(value =>
          zio.aws.licensemanagerlinuxsubscriptions.model.Operator.wrap(value)
        )
    override val values: Optional[List[StringListMemberString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.values())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.licensemanagerlinuxsubscriptions.model.primitives
              .StringListMemberString(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.Filter
  ): zio.aws.licensemanagerlinuxsubscriptions.model.Filter.ReadOnly =
    new Wrapper(impl)
}
