package zio.aws.licensemanagerlinuxsubscriptions.model
import scala.jdk.CollectionConverters._
sealed trait LinuxSubscriptionsDiscovery {
  def unwrap
      : software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.LinuxSubscriptionsDiscovery
}
object LinuxSubscriptionsDiscovery {
  def wrap(
      value: software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.LinuxSubscriptionsDiscovery
  ): zio.aws.licensemanagerlinuxsubscriptions.model.LinuxSubscriptionsDiscovery =
    value match {
      case software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.LinuxSubscriptionsDiscovery.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.LinuxSubscriptionsDiscovery.ENABLED =>
        val r = Enabled
        r
      case software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.LinuxSubscriptionsDiscovery.DISABLED =>
        val r = Disabled
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.licensemanagerlinuxsubscriptions.model.LinuxSubscriptionsDiscovery {
    override def unwrap
        : software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.LinuxSubscriptionsDiscovery =
      software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.LinuxSubscriptionsDiscovery.UNKNOWN_TO_SDK_VERSION
  }
  case object Enabled
      extends zio.aws.licensemanagerlinuxsubscriptions.model.LinuxSubscriptionsDiscovery {
    override def unwrap
        : software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.LinuxSubscriptionsDiscovery =
      software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.LinuxSubscriptionsDiscovery.ENABLED
  }
  case object Disabled
      extends zio.aws.licensemanagerlinuxsubscriptions.model.LinuxSubscriptionsDiscovery {
    override def unwrap
        : software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.LinuxSubscriptionsDiscovery =
      software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.LinuxSubscriptionsDiscovery.DISABLED
  }
}
