package zio.aws.lexruntimev2.model
import scala.jdk.CollectionConverters.*
sealed trait Shape {
  def unwrap: software.amazon.awssdk.services.lexruntimev2.model.Shape
}
object Shape {
  def wrap(
      value: software.amazon.awssdk.services.lexruntimev2.model.Shape
  ): zio.aws.lexruntimev2.model.Shape = value match {
    case software.amazon.awssdk.services.lexruntimev2.model.Shape.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lexruntimev2.model.Shape.SCALAR =>
      val r = Scalar
      r
    case software.amazon.awssdk.services.lexruntimev2.model.Shape.LIST =>
      val r = List
      r
    case software.amazon.awssdk.services.lexruntimev2.model.Shape.COMPOSITE =>
      val r = Composite
      r
  }
  case object unknownToSdkVersion extends zio.aws.lexruntimev2.model.Shape {
    override def unwrap
        : software.amazon.awssdk.services.lexruntimev2.model.Shape =
      software.amazon.awssdk.services.lexruntimev2.model.Shape.UNKNOWN_TO_SDK_VERSION
  }
  case object Scalar extends zio.aws.lexruntimev2.model.Shape {
    override def unwrap
        : software.amazon.awssdk.services.lexruntimev2.model.Shape =
      software.amazon.awssdk.services.lexruntimev2.model.Shape.SCALAR
  }
  case object List extends zio.aws.lexruntimev2.model.Shape {
    override def unwrap
        : software.amazon.awssdk.services.lexruntimev2.model.Shape =
      software.amazon.awssdk.services.lexruntimev2.model.Shape.LIST
  }
  case object Composite extends zio.aws.lexruntimev2.model.Shape {
    override def unwrap
        : software.amazon.awssdk.services.lexruntimev2.model.Shape =
      software.amazon.awssdk.services.lexruntimev2.model.Shape.COMPOSITE
  }
}
