package zio.aws.lexruntimev2.model
import java.lang.Integer
import zio.aws.lexruntimev2.model.primitives.{
  ActiveContextTurnsToLive,
  ActiveContextTimeToLiveInSeconds
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ActiveContextTimeToLive(
    timeToLiveInSeconds: ActiveContextTimeToLiveInSeconds,
    turnsToLive: ActiveContextTurnsToLive
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntimev2.model.ActiveContextTimeToLive = {
    import ActiveContextTimeToLive.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntimev2.model.ActiveContextTimeToLive
      .builder()
      .timeToLiveInSeconds(
        ActiveContextTimeToLiveInSeconds.unwrap(timeToLiveInSeconds): Integer
      )
      .turnsToLive(ActiveContextTurnsToLive.unwrap(turnsToLive): Integer)
      .build()
  }
  def asReadOnly: zio.aws.lexruntimev2.model.ActiveContextTimeToLive.ReadOnly =
    zio.aws.lexruntimev2.model.ActiveContextTimeToLive.wrap(buildAwsValue())
}
object ActiveContextTimeToLive {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntimev2.model.ActiveContextTimeToLive
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexruntimev2.model.ActiveContextTimeToLive =
      zio.aws.lexruntimev2.model
        .ActiveContextTimeToLive(timeToLiveInSeconds, turnsToLive)
    def timeToLiveInSeconds: ActiveContextTimeToLiveInSeconds
    def turnsToLive: ActiveContextTurnsToLive
    def getTimeToLiveInSeconds
        : ZIO[Any, Nothing, ActiveContextTimeToLiveInSeconds] =
      ZIO.succeed(timeToLiveInSeconds)
    def getTurnsToLive: ZIO[Any, Nothing, ActiveContextTurnsToLive] =
      ZIO.succeed(turnsToLive)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexruntimev2.model.ActiveContextTimeToLive
  ) extends zio.aws.lexruntimev2.model.ActiveContextTimeToLive.ReadOnly {
    override val timeToLiveInSeconds: ActiveContextTimeToLiveInSeconds =
      zio.aws.lexruntimev2.model.primitives
        .ActiveContextTimeToLiveInSeconds(impl.timeToLiveInSeconds())
    override val turnsToLive: ActiveContextTurnsToLive =
      zio.aws.lexruntimev2.model.primitives
        .ActiveContextTurnsToLive(impl.turnsToLive())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntimev2.model.ActiveContextTimeToLive
  ): zio.aws.lexruntimev2.model.ActiveContextTimeToLive.ReadOnly = new Wrapper(
    impl
  )
}
