package zio.aws.lexruntimev2.model
import scala.jdk.CollectionConverters.*
sealed trait SentimentType {
  def unwrap: software.amazon.awssdk.services.lexruntimev2.model.SentimentType
}
object SentimentType {
  def wrap(
      value: software.amazon.awssdk.services.lexruntimev2.model.SentimentType
  ): zio.aws.lexruntimev2.model.SentimentType = value match {
    case software.amazon.awssdk.services.lexruntimev2.model.SentimentType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lexruntimev2.model.SentimentType.MIXED =>
      val r = MIXED
      r
    case software.amazon.awssdk.services.lexruntimev2.model.SentimentType.NEGATIVE =>
      val r = NEGATIVE
      r
    case software.amazon.awssdk.services.lexruntimev2.model.SentimentType.NEUTRAL =>
      val r = NEUTRAL
      r
    case software.amazon.awssdk.services.lexruntimev2.model.SentimentType.POSITIVE =>
      val r = POSITIVE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lexruntimev2.model.SentimentType {
    override def unwrap
        : software.amazon.awssdk.services.lexruntimev2.model.SentimentType =
      software.amazon.awssdk.services.lexruntimev2.model.SentimentType.UNKNOWN_TO_SDK_VERSION
  }
  case object MIXED extends zio.aws.lexruntimev2.model.SentimentType {
    override def unwrap
        : software.amazon.awssdk.services.lexruntimev2.model.SentimentType =
      software.amazon.awssdk.services.lexruntimev2.model.SentimentType.MIXED
  }
  case object NEGATIVE extends zio.aws.lexruntimev2.model.SentimentType {
    override def unwrap
        : software.amazon.awssdk.services.lexruntimev2.model.SentimentType =
      software.amazon.awssdk.services.lexruntimev2.model.SentimentType.NEGATIVE
  }
  case object NEUTRAL extends zio.aws.lexruntimev2.model.SentimentType {
    override def unwrap
        : software.amazon.awssdk.services.lexruntimev2.model.SentimentType =
      software.amazon.awssdk.services.lexruntimev2.model.SentimentType.NEUTRAL
  }
  case object POSITIVE extends zio.aws.lexruntimev2.model.SentimentType {
    override def unwrap
        : software.amazon.awssdk.services.lexruntimev2.model.SentimentType =
      software.amazon.awssdk.services.lexruntimev2.model.SentimentType.POSITIVE
  }
}
