package zio.aws.lexruntimev2.model
import zio.aws.lexruntimev2.model.primitives.{SessionId, NonEmptyString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RecognizeUtteranceResponse(
    inputMode: Optional[NonEmptyString] = Optional.Absent,
    contentType: Optional[NonEmptyString] = Optional.Absent,
    messages: Optional[NonEmptyString] = Optional.Absent,
    interpretations: Optional[NonEmptyString] = Optional.Absent,
    sessionState: Optional[NonEmptyString] = Optional.Absent,
    requestAttributes: Optional[NonEmptyString] = Optional.Absent,
    sessionId: Optional[SessionId] = Optional.Absent,
    inputTranscript: Optional[NonEmptyString] = Optional.Absent,
    recognizedBotMember: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntimev2.model.RecognizeUtteranceResponse = {
    import RecognizeUtteranceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntimev2.model.RecognizeUtteranceResponse
      .builder()
      .optionallyWith(
        inputMode.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.inputMode)
      .optionallyWith(
        contentType.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.contentType)
      .optionallyWith(
        messages.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.messages)
      .optionallyWith(
        interpretations.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.interpretations)
      .optionallyWith(
        sessionState.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.sessionState)
      .optionallyWith(
        requestAttributes.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.requestAttributes)
      .optionallyWith(
        sessionId.map(value => SessionId.unwrap(value): java.lang.String)
      )(_.sessionId)
      .optionallyWith(
        inputTranscript.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.inputTranscript)
      .optionallyWith(
        recognizedBotMember.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.recognizedBotMember)
      .build()
  }
  def asReadOnly
      : zio.aws.lexruntimev2.model.RecognizeUtteranceResponse.ReadOnly =
    zio.aws.lexruntimev2.model.RecognizeUtteranceResponse.wrap(buildAwsValue())
}
object RecognizeUtteranceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntimev2.model.RecognizeUtteranceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexruntimev2.model.RecognizeUtteranceResponse =
      zio.aws.lexruntimev2.model.RecognizeUtteranceResponse(
        inputMode.map(value => value),
        contentType.map(value => value),
        messages.map(value => value),
        interpretations.map(value => value),
        sessionState.map(value => value),
        requestAttributes.map(value => value),
        sessionId.map(value => value),
        inputTranscript.map(value => value),
        recognizedBotMember.map(value => value)
      )
    def inputMode: Optional[NonEmptyString]
    def contentType: Optional[NonEmptyString]
    def messages: Optional[NonEmptyString]
    def interpretations: Optional[NonEmptyString]
    def sessionState: Optional[NonEmptyString]
    def requestAttributes: Optional[NonEmptyString]
    def sessionId: Optional[SessionId]
    def inputTranscript: Optional[NonEmptyString]
    def recognizedBotMember: Optional[NonEmptyString]
    def getInputMode: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("inputMode", inputMode)
    def getContentType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("contentType", contentType)
    def getMessages: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("messages", messages)
    def getInterpretations: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("interpretations", interpretations)
    def getSessionState: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("sessionState", sessionState)
    def getRequestAttributes: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("requestAttributes", requestAttributes)
    def getSessionId: ZIO[Any, AwsError, SessionId] =
      AwsError.unwrapOptionField("sessionId", sessionId)
    def getInputTranscript: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("inputTranscript", inputTranscript)
    def getRecognizedBotMember: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("recognizedBotMember", recognizedBotMember)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexruntimev2.model.RecognizeUtteranceResponse
  ) extends zio.aws.lexruntimev2.model.RecognizeUtteranceResponse.ReadOnly {
    override val inputMode: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.inputMode())
      .map(value => zio.aws.lexruntimev2.model.primitives.NonEmptyString(value))
    override val contentType: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.contentType())
      .map(value => zio.aws.lexruntimev2.model.primitives.NonEmptyString(value))
    override val messages: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.messages())
      .map(value => zio.aws.lexruntimev2.model.primitives.NonEmptyString(value))
    override val interpretations: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.interpretations())
        .map(value =>
          zio.aws.lexruntimev2.model.primitives.NonEmptyString(value)
        )
    override val sessionState: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.sessionState())
      .map(value => zio.aws.lexruntimev2.model.primitives.NonEmptyString(value))
    override val requestAttributes: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requestAttributes())
        .map(value =>
          zio.aws.lexruntimev2.model.primitives.NonEmptyString(value)
        )
    override val sessionId: Optional[SessionId] = zio.aws.core.internal
      .optionalFromNullable(impl.sessionId())
      .map(value => zio.aws.lexruntimev2.model.primitives.SessionId(value))
    override val inputTranscript: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inputTranscript())
        .map(value =>
          zio.aws.lexruntimev2.model.primitives.NonEmptyString(value)
        )
    override val recognizedBotMember: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recognizedBotMember())
        .map(value =>
          zio.aws.lexruntimev2.model.primitives.NonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntimev2.model.RecognizeUtteranceResponse
  ): zio.aws.lexruntimev2.model.RecognizeUtteranceResponse.ReadOnly =
    new Wrapper(impl)
}
