package zio.aws.lexruntimev2.model
import scala.jdk.CollectionConverters.*
sealed trait ConfirmationState {
  def unwrap
      : software.amazon.awssdk.services.lexruntimev2.model.ConfirmationState
}
object ConfirmationState {
  def wrap(
      value: software.amazon.awssdk.services.lexruntimev2.model.ConfirmationState
  ): zio.aws.lexruntimev2.model.ConfirmationState = value match {
    case software.amazon.awssdk.services.lexruntimev2.model.ConfirmationState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lexruntimev2.model.ConfirmationState.CONFIRMED =>
      val r = Confirmed
      r
    case software.amazon.awssdk.services.lexruntimev2.model.ConfirmationState.DENIED =>
      val r = Denied
      r
    case software.amazon.awssdk.services.lexruntimev2.model.ConfirmationState.NONE =>
      val r = None
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lexruntimev2.model.ConfirmationState {
    override def unwrap
        : software.amazon.awssdk.services.lexruntimev2.model.ConfirmationState =
      software.amazon.awssdk.services.lexruntimev2.model.ConfirmationState.UNKNOWN_TO_SDK_VERSION
  }
  case object Confirmed extends zio.aws.lexruntimev2.model.ConfirmationState {
    override def unwrap
        : software.amazon.awssdk.services.lexruntimev2.model.ConfirmationState =
      software.amazon.awssdk.services.lexruntimev2.model.ConfirmationState.CONFIRMED
  }
  case object Denied extends zio.aws.lexruntimev2.model.ConfirmationState {
    override def unwrap
        : software.amazon.awssdk.services.lexruntimev2.model.ConfirmationState =
      software.amazon.awssdk.services.lexruntimev2.model.ConfirmationState.DENIED
  }
  case object None extends zio.aws.lexruntimev2.model.ConfirmationState {
    override def unwrap
        : software.amazon.awssdk.services.lexruntimev2.model.ConfirmationState =
      software.amazon.awssdk.services.lexruntimev2.model.ConfirmationState.NONE
  }
}
