package zio.aws.lexruntimev2.model
import zio.aws.lexruntimev2.model.primitives.{
  SessionId,
  LocaleId,
  BotAliasIdentifier,
  BotIdentifier
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StartConversationRequest(
    botId: BotIdentifier,
    botAliasId: BotAliasIdentifier,
    localeId: LocaleId,
    sessionId: SessionId,
    conversationMode: Optional[zio.aws.lexruntimev2.model.ConversationMode] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntimev2.model.StartConversationRequest = {
    import StartConversationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntimev2.model.StartConversationRequest
      .builder()
      .botId(BotIdentifier.unwrap(botId): java.lang.String)
      .botAliasId(BotAliasIdentifier.unwrap(botAliasId): java.lang.String)
      .localeId(LocaleId.unwrap(localeId): java.lang.String)
      .sessionId(SessionId.unwrap(sessionId): java.lang.String)
      .optionallyWith(conversationMode.map(value => value.unwrap))(
        _.conversationMode
      )
      .build()
  }
  def asReadOnly: zio.aws.lexruntimev2.model.StartConversationRequest.ReadOnly =
    zio.aws.lexruntimev2.model.StartConversationRequest.wrap(buildAwsValue())
}
object StartConversationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntimev2.model.StartConversationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexruntimev2.model.StartConversationRequest =
      zio.aws.lexruntimev2.model.StartConversationRequest(
        botId,
        botAliasId,
        localeId,
        sessionId,
        conversationMode.map(value => value)
      )
    def botId: BotIdentifier
    def botAliasId: BotAliasIdentifier
    def localeId: LocaleId
    def sessionId: SessionId
    def conversationMode: Optional[zio.aws.lexruntimev2.model.ConversationMode]
    def getBotId: ZIO[Any, Nothing, BotIdentifier] = ZIO.succeed(botId)
    def getBotAliasId: ZIO[Any, Nothing, BotAliasIdentifier] =
      ZIO.succeed(botAliasId)
    def getLocaleId: ZIO[Any, Nothing, LocaleId] = ZIO.succeed(localeId)
    def getSessionId: ZIO[Any, Nothing, SessionId] = ZIO.succeed(sessionId)
    def getConversationMode
        : ZIO[Any, AwsError, zio.aws.lexruntimev2.model.ConversationMode] =
      AwsError.unwrapOptionField("conversationMode", conversationMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexruntimev2.model.StartConversationRequest
  ) extends zio.aws.lexruntimev2.model.StartConversationRequest.ReadOnly {
    override val botId: BotIdentifier =
      zio.aws.lexruntimev2.model.primitives.BotIdentifier(impl.botId())
    override val botAliasId: BotAliasIdentifier =
      zio.aws.lexruntimev2.model.primitives
        .BotAliasIdentifier(impl.botAliasId())
    override val localeId: LocaleId =
      zio.aws.lexruntimev2.model.primitives.LocaleId(impl.localeId())
    override val sessionId: SessionId =
      zio.aws.lexruntimev2.model.primitives.SessionId(impl.sessionId())
    override val conversationMode
        : Optional[zio.aws.lexruntimev2.model.ConversationMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.conversationMode())
        .map(value => zio.aws.lexruntimev2.model.ConversationMode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntimev2.model.StartConversationRequest
  ): zio.aws.lexruntimev2.model.StartConversationRequest.ReadOnly = new Wrapper(
    impl
  )
}
