package zio.aws.lexruntimev2.model
import scala.jdk.CollectionConverters.*
sealed trait DialogActionType {
  def unwrap
      : software.amazon.awssdk.services.lexruntimev2.model.DialogActionType
}
object DialogActionType {
  def wrap(
      value: software.amazon.awssdk.services.lexruntimev2.model.DialogActionType
  ): zio.aws.lexruntimev2.model.DialogActionType = value match {
    case software.amazon.awssdk.services.lexruntimev2.model.DialogActionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lexruntimev2.model.DialogActionType.CLOSE =>
      val r = Close
      r
    case software.amazon.awssdk.services.lexruntimev2.model.DialogActionType.CONFIRM_INTENT =>
      val r = ConfirmIntent
      r
    case software.amazon.awssdk.services.lexruntimev2.model.DialogActionType.DELEGATE =>
      val r = Delegate
      r
    case software.amazon.awssdk.services.lexruntimev2.model.DialogActionType.ELICIT_INTENT =>
      val r = ElicitIntent
      r
    case software.amazon.awssdk.services.lexruntimev2.model.DialogActionType.ELICIT_SLOT =>
      val r = ElicitSlot
      r
    case software.amazon.awssdk.services.lexruntimev2.model.DialogActionType.NONE =>
      val r = None
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lexruntimev2.model.DialogActionType {
    override def unwrap
        : software.amazon.awssdk.services.lexruntimev2.model.DialogActionType =
      software.amazon.awssdk.services.lexruntimev2.model.DialogActionType.UNKNOWN_TO_SDK_VERSION
  }
  case object Close extends zio.aws.lexruntimev2.model.DialogActionType {
    override def unwrap
        : software.amazon.awssdk.services.lexruntimev2.model.DialogActionType =
      software.amazon.awssdk.services.lexruntimev2.model.DialogActionType.CLOSE
  }
  case object ConfirmIntent
      extends zio.aws.lexruntimev2.model.DialogActionType {
    override def unwrap
        : software.amazon.awssdk.services.lexruntimev2.model.DialogActionType =
      software.amazon.awssdk.services.lexruntimev2.model.DialogActionType.CONFIRM_INTENT
  }
  case object Delegate extends zio.aws.lexruntimev2.model.DialogActionType {
    override def unwrap
        : software.amazon.awssdk.services.lexruntimev2.model.DialogActionType =
      software.amazon.awssdk.services.lexruntimev2.model.DialogActionType.DELEGATE
  }
  case object ElicitIntent extends zio.aws.lexruntimev2.model.DialogActionType {
    override def unwrap
        : software.amazon.awssdk.services.lexruntimev2.model.DialogActionType =
      software.amazon.awssdk.services.lexruntimev2.model.DialogActionType.ELICIT_INTENT
  }
  case object ElicitSlot extends zio.aws.lexruntimev2.model.DialogActionType {
    override def unwrap
        : software.amazon.awssdk.services.lexruntimev2.model.DialogActionType =
      software.amazon.awssdk.services.lexruntimev2.model.DialogActionType.ELICIT_SLOT
  }
  case object None extends zio.aws.lexruntimev2.model.DialogActionType {
    override def unwrap
        : software.amazon.awssdk.services.lexruntimev2.model.DialogActionType =
      software.amazon.awssdk.services.lexruntimev2.model.DialogActionType.NONE
  }
}
