package zio.aws.lexruntimev2.model
import zio.aws.lexruntimev2.model.primitives.{
  SessionId,
  LocaleId,
  BotAliasIdentifier,
  BotIdentifier
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteSessionResponse(
    botId: Optional[BotIdentifier] = Optional.Absent,
    botAliasId: Optional[BotAliasIdentifier] = Optional.Absent,
    localeId: Optional[LocaleId] = Optional.Absent,
    sessionId: Optional[SessionId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntimev2.model.DeleteSessionResponse = {
    import DeleteSessionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntimev2.model.DeleteSessionResponse
      .builder()
      .optionallyWith(
        botId.map(value => BotIdentifier.unwrap(value): java.lang.String)
      )(_.botId)
      .optionallyWith(
        botAliasId.map(value =>
          BotAliasIdentifier.unwrap(value): java.lang.String
        )
      )(_.botAliasId)
      .optionallyWith(
        localeId.map(value => LocaleId.unwrap(value): java.lang.String)
      )(_.localeId)
      .optionallyWith(
        sessionId.map(value => SessionId.unwrap(value): java.lang.String)
      )(_.sessionId)
      .build()
  }
  def asReadOnly: zio.aws.lexruntimev2.model.DeleteSessionResponse.ReadOnly =
    zio.aws.lexruntimev2.model.DeleteSessionResponse.wrap(buildAwsValue())
}
object DeleteSessionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntimev2.model.DeleteSessionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexruntimev2.model.DeleteSessionResponse =
      zio.aws.lexruntimev2.model.DeleteSessionResponse(
        botId.map(value => value),
        botAliasId.map(value => value),
        localeId.map(value => value),
        sessionId.map(value => value)
      )
    def botId: Optional[BotIdentifier]
    def botAliasId: Optional[BotAliasIdentifier]
    def localeId: Optional[LocaleId]
    def sessionId: Optional[SessionId]
    def getBotId: ZIO[Any, AwsError, BotIdentifier] =
      AwsError.unwrapOptionField("botId", botId)
    def getBotAliasId: ZIO[Any, AwsError, BotAliasIdentifier] =
      AwsError.unwrapOptionField("botAliasId", botAliasId)
    def getLocaleId: ZIO[Any, AwsError, LocaleId] =
      AwsError.unwrapOptionField("localeId", localeId)
    def getSessionId: ZIO[Any, AwsError, SessionId] =
      AwsError.unwrapOptionField("sessionId", sessionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexruntimev2.model.DeleteSessionResponse
  ) extends zio.aws.lexruntimev2.model.DeleteSessionResponse.ReadOnly {
    override val botId: Optional[BotIdentifier] = zio.aws.core.internal
      .optionalFromNullable(impl.botId())
      .map(value => zio.aws.lexruntimev2.model.primitives.BotIdentifier(value))
    override val botAliasId: Optional[BotAliasIdentifier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.botAliasId())
        .map(value =>
          zio.aws.lexruntimev2.model.primitives.BotAliasIdentifier(value)
        )
    override val localeId: Optional[LocaleId] = zio.aws.core.internal
      .optionalFromNullable(impl.localeId())
      .map(value => zio.aws.lexruntimev2.model.primitives.LocaleId(value))
    override val sessionId: Optional[SessionId] = zio.aws.core.internal
      .optionalFromNullable(impl.sessionId())
      .map(value => zio.aws.lexruntimev2.model.primitives.SessionId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntimev2.model.DeleteSessionResponse
  ): zio.aws.lexruntimev2.model.DeleteSessionResponse.ReadOnly = new Wrapper(
    impl
  )
}
