package zio.aws.lexruntimev2.model
import zio.aws.lexruntimev2.model.primitives.{
  EpochMillis,
  EventId,
  NonEmptyString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ConfigurationEvent(
    requestAttributes: Optional[Map[NonEmptyString, String]] = Optional.Absent,
    responseContentType: NonEmptyString,
    sessionState: Optional[zio.aws.lexruntimev2.model.SessionState] =
      Optional.Absent,
    welcomeMessages: Optional[Iterable[zio.aws.lexruntimev2.model.Message]] =
      Optional.Absent,
    disablePlayback: Optional[Boolean] = Optional.Absent,
    eventId: Optional[EventId] = Optional.Absent,
    clientTimestampMillis: Optional[EpochMillis] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntimev2.model.ConfigurationEvent = {
    import ConfigurationEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntimev2.model.ConfigurationEvent
      .builder()
      .optionallyWith(
        requestAttributes.map(value =>
          value
            .map({ case (key, value) =>
              (NonEmptyString.unwrap(
                key
              ): java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.requestAttributes)
      .responseContentType(
        NonEmptyString.unwrap(responseContentType): java.lang.String
      )
      .optionallyWith(sessionState.map(value => value.buildAwsValue()))(
        _.sessionState
      )
      .optionallyWith(
        welcomeMessages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.welcomeMessages)
      .optionallyWith(disablePlayback.map(value => value: java.lang.Boolean))(
        _.disablePlayback
      )
      .optionallyWith(
        eventId.map(value => EventId.unwrap(value): java.lang.String)
      )(_.eventId)
      .optionallyWith(
        clientTimestampMillis.map(value =>
          EpochMillis.unwrap(value): java.lang.Long
        )
      )(_.clientTimestampMillis)
      .build()
  }
  def asReadOnly: zio.aws.lexruntimev2.model.ConfigurationEvent.ReadOnly =
    zio.aws.lexruntimev2.model.ConfigurationEvent.wrap(buildAwsValue())
}
object ConfigurationEvent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntimev2.model.ConfigurationEvent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexruntimev2.model.ConfigurationEvent =
      zio.aws.lexruntimev2.model.ConfigurationEvent(
        requestAttributes.map(value => value),
        responseContentType,
        sessionState.map(value => value.asEditable),
        welcomeMessages.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        disablePlayback.map(value => value),
        eventId.map(value => value),
        clientTimestampMillis.map(value => value)
      )
    def requestAttributes: Optional[Map[NonEmptyString, String]]
    def responseContentType: NonEmptyString
    def sessionState: Optional[zio.aws.lexruntimev2.model.SessionState.ReadOnly]
    def welcomeMessages
        : Optional[List[zio.aws.lexruntimev2.model.Message.ReadOnly]]
    def disablePlayback: Optional[Boolean]
    def eventId: Optional[EventId]
    def clientTimestampMillis: Optional[EpochMillis]
    def getRequestAttributes: ZIO[Any, AwsError, Map[NonEmptyString, String]] =
      AwsError.unwrapOptionField("requestAttributes", requestAttributes)
    def getResponseContentType: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(responseContentType)
    def getSessionState
        : ZIO[Any, AwsError, zio.aws.lexruntimev2.model.SessionState.ReadOnly] =
      AwsError.unwrapOptionField("sessionState", sessionState)
    def getWelcomeMessages: ZIO[Any, AwsError, List[
      zio.aws.lexruntimev2.model.Message.ReadOnly
    ]] = AwsError.unwrapOptionField("welcomeMessages", welcomeMessages)
    def getDisablePlayback: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("disablePlayback", disablePlayback)
    def getEventId: ZIO[Any, AwsError, EventId] =
      AwsError.unwrapOptionField("eventId", eventId)
    def getClientTimestampMillis: ZIO[Any, AwsError, EpochMillis] =
      AwsError.unwrapOptionField("clientTimestampMillis", clientTimestampMillis)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexruntimev2.model.ConfigurationEvent
  ) extends zio.aws.lexruntimev2.model.ConfigurationEvent.ReadOnly {
    override val requestAttributes: Optional[Map[NonEmptyString, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requestAttributes())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.lexruntimev2.model.primitives
                .NonEmptyString(key) -> (value: String)
            })
            .toMap
        )
    override val responseContentType: NonEmptyString =
      zio.aws.lexruntimev2.model.primitives
        .NonEmptyString(impl.responseContentType())
    override val sessionState
        : Optional[zio.aws.lexruntimev2.model.SessionState.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sessionState())
        .map(value => zio.aws.lexruntimev2.model.SessionState.wrap(value))
    override val welcomeMessages
        : Optional[List[zio.aws.lexruntimev2.model.Message.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.welcomeMessages())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexruntimev2.model.Message.wrap(item)
          }.toList
        )
    override val disablePlayback: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.disablePlayback())
      .map(value => value: Boolean)
    override val eventId: Optional[EventId] = zio.aws.core.internal
      .optionalFromNullable(impl.eventId())
      .map(value => zio.aws.lexruntimev2.model.primitives.EventId(value))
    override val clientTimestampMillis: Optional[EpochMillis] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientTimestampMillis())
        .map(value => zio.aws.lexruntimev2.model.primitives.EpochMillis(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntimev2.model.ConfigurationEvent
  ): zio.aws.lexruntimev2.model.ConfigurationEvent.ReadOnly = new Wrapper(impl)
}
