package zio.aws.lexruntimev2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class RuntimeHintDetails(
    runtimeHintValues: Iterable[zio.aws.lexruntimev2.model.RuntimeHintValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntimev2.model.RuntimeHintDetails = {
    import RuntimeHintDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntimev2.model.RuntimeHintDetails
      .builder()
      .runtimeHintValues(runtimeHintValues.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.lexruntimev2.model.RuntimeHintDetails.ReadOnly =
    zio.aws.lexruntimev2.model.RuntimeHintDetails.wrap(buildAwsValue())
}
object RuntimeHintDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntimev2.model.RuntimeHintDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexruntimev2.model.RuntimeHintDetails =
      zio.aws.lexruntimev2.model.RuntimeHintDetails(runtimeHintValues.map {
        item =>
          item.asEditable
      })
    def runtimeHintValues
        : List[zio.aws.lexruntimev2.model.RuntimeHintValue.ReadOnly]
    def getRuntimeHintValues: ZIO[Any, Nothing, List[
      zio.aws.lexruntimev2.model.RuntimeHintValue.ReadOnly
    ]] = ZIO.succeed(runtimeHintValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexruntimev2.model.RuntimeHintDetails
  ) extends zio.aws.lexruntimev2.model.RuntimeHintDetails.ReadOnly {
    override val runtimeHintValues
        : List[zio.aws.lexruntimev2.model.RuntimeHintValue.ReadOnly] = impl
      .runtimeHintValues()
      .asScala
      .map { item =>
        zio.aws.lexruntimev2.model.RuntimeHintValue.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntimev2.model.RuntimeHintDetails
  ): zio.aws.lexruntimev2.model.RuntimeHintDetails.ReadOnly = new Wrapper(impl)
}
