package zio.aws.lexruntimev2.model
import zio.aws.lexruntimev2.model.primitives.Text
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Message(
    content: Optional[Text] = Optional.Absent,
    contentType: zio.aws.lexruntimev2.model.MessageContentType,
    imageResponseCard: Optional[zio.aws.lexruntimev2.model.ImageResponseCard] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntimev2.model.Message = {
    import Message.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntimev2.model.Message
      .builder()
      .optionallyWith(
        content.map(value => Text.unwrap(value): java.lang.String)
      )(_.content)
      .contentType(contentType.unwrap)
      .optionallyWith(imageResponseCard.map(value => value.buildAwsValue()))(
        _.imageResponseCard
      )
      .build()
  }
  def asReadOnly: zio.aws.lexruntimev2.model.Message.ReadOnly =
    zio.aws.lexruntimev2.model.Message.wrap(buildAwsValue())
}
object Message {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntimev2.model.Message
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexruntimev2.model.Message =
      zio.aws.lexruntimev2.model.Message(
        content.map(value => value),
        contentType,
        imageResponseCard.map(value => value.asEditable)
      )
    def content: Optional[Text]
    def contentType: zio.aws.lexruntimev2.model.MessageContentType
    def imageResponseCard
        : Optional[zio.aws.lexruntimev2.model.ImageResponseCard.ReadOnly]
    def getContent: ZIO[Any, AwsError, Text] =
      AwsError.unwrapOptionField("content", content)
    def getContentType
        : ZIO[Any, Nothing, zio.aws.lexruntimev2.model.MessageContentType] =
      ZIO.succeed(contentType)
    def getImageResponseCard: ZIO[
      Any,
      AwsError,
      zio.aws.lexruntimev2.model.ImageResponseCard.ReadOnly
    ] = AwsError.unwrapOptionField("imageResponseCard", imageResponseCard)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexruntimev2.model.Message
  ) extends zio.aws.lexruntimev2.model.Message.ReadOnly {
    override val content: Optional[Text] = zio.aws.core.internal
      .optionalFromNullable(impl.content())
      .map(value => zio.aws.lexruntimev2.model.primitives.Text(value))
    override val contentType: zio.aws.lexruntimev2.model.MessageContentType =
      zio.aws.lexruntimev2.model.MessageContentType.wrap(impl.contentType())
    override val imageResponseCard
        : Optional[zio.aws.lexruntimev2.model.ImageResponseCard.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imageResponseCard())
        .map(value => zio.aws.lexruntimev2.model.ImageResponseCard.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntimev2.model.Message
  ): zio.aws.lexruntimev2.model.Message.ReadOnly = new Wrapper(impl)
}
