package zio.aws.lexruntimev2.model
import zio.aws.lexruntimev2.model.primitives.{SessionId, NonEmptyString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RecognizeTextResponse(
    messages: Optional[Iterable[zio.aws.lexruntimev2.model.Message]] =
      Optional.Absent,
    sessionState: Optional[zio.aws.lexruntimev2.model.SessionState] =
      Optional.Absent,
    interpretations: Optional[
      Iterable[zio.aws.lexruntimev2.model.Interpretation]
    ] = Optional.Absent,
    requestAttributes: Optional[Map[NonEmptyString, String]] = Optional.Absent,
    sessionId: Optional[SessionId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntimev2.model.RecognizeTextResponse = {
    import RecognizeTextResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntimev2.model.RecognizeTextResponse
      .builder()
      .optionallyWith(
        messages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.messages)
      .optionallyWith(sessionState.map(value => value.buildAwsValue()))(
        _.sessionState
      )
      .optionallyWith(
        interpretations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.interpretations)
      .optionallyWith(
        requestAttributes.map(value =>
          value
            .map({ case (key, value) =>
              (NonEmptyString
                .unwrap(key): java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.requestAttributes)
      .optionallyWith(
        sessionId.map(value => SessionId.unwrap(value): java.lang.String)
      )(_.sessionId)
      .build()
  }
  def asReadOnly: zio.aws.lexruntimev2.model.RecognizeTextResponse.ReadOnly =
    zio.aws.lexruntimev2.model.RecognizeTextResponse.wrap(buildAwsValue())
}
object RecognizeTextResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntimev2.model.RecognizeTextResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexruntimev2.model.RecognizeTextResponse =
      zio.aws.lexruntimev2.model.RecognizeTextResponse(
        messages.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sessionState.map(value => value.asEditable),
        interpretations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        requestAttributes.map(value => value),
        sessionId.map(value => value)
      )
    def messages: Optional[List[zio.aws.lexruntimev2.model.Message.ReadOnly]]
    def sessionState: Optional[zio.aws.lexruntimev2.model.SessionState.ReadOnly]
    def interpretations
        : Optional[List[zio.aws.lexruntimev2.model.Interpretation.ReadOnly]]
    def requestAttributes: Optional[Map[NonEmptyString, String]]
    def sessionId: Optional[SessionId]
    def getMessages: ZIO[Any, AwsError, List[
      zio.aws.lexruntimev2.model.Message.ReadOnly
    ]] = AwsError.unwrapOptionField("messages", messages)
    def getSessionState
        : ZIO[Any, AwsError, zio.aws.lexruntimev2.model.SessionState.ReadOnly] =
      AwsError.unwrapOptionField("sessionState", sessionState)
    def getInterpretations: ZIO[Any, AwsError, List[
      zio.aws.lexruntimev2.model.Interpretation.ReadOnly
    ]] = AwsError.unwrapOptionField("interpretations", interpretations)
    def getRequestAttributes: ZIO[Any, AwsError, Map[NonEmptyString, String]] =
      AwsError.unwrapOptionField("requestAttributes", requestAttributes)
    def getSessionId: ZIO[Any, AwsError, SessionId] =
      AwsError.unwrapOptionField("sessionId", sessionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexruntimev2.model.RecognizeTextResponse
  ) extends zio.aws.lexruntimev2.model.RecognizeTextResponse.ReadOnly {
    override val messages
        : Optional[List[zio.aws.lexruntimev2.model.Message.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.messages())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexruntimev2.model.Message.wrap(item)
          }.toList
        )
    override val sessionState
        : Optional[zio.aws.lexruntimev2.model.SessionState.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sessionState())
        .map(value => zio.aws.lexruntimev2.model.SessionState.wrap(value))
    override val interpretations
        : Optional[List[zio.aws.lexruntimev2.model.Interpretation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.interpretations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexruntimev2.model.Interpretation.wrap(item)
          }.toList
        )
    override val requestAttributes: Optional[Map[NonEmptyString, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requestAttributes())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.lexruntimev2.model.primitives
                .NonEmptyString(key) -> (value: String)
            })
            .toMap
        )
    override val sessionId: Optional[SessionId] = zio.aws.core.internal
      .optionalFromNullable(impl.sessionId())
      .map(value => zio.aws.lexruntimev2.model.primitives.SessionId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntimev2.model.RecognizeTextResponse
  ): zio.aws.lexruntimev2.model.RecognizeTextResponse.ReadOnly = new Wrapper(
    impl
  )
}
