package zio.aws.lexruntimev2.model
import zio.aws.lexruntimev2.model.primitives.{SessionId, NonEmptyString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RecognizeUtteranceResponse(
    inputMode: Option[NonEmptyString] = None,
    contentType: Option[NonEmptyString] = None,
    messages: Option[NonEmptyString] = None,
    interpretations: Option[NonEmptyString] = None,
    sessionState: Option[NonEmptyString] = None,
    requestAttributes: Option[NonEmptyString] = None,
    sessionId: Option[SessionId] = None,
    inputTranscript: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntimev2.model.RecognizeUtteranceResponse = {
    import RecognizeUtteranceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntimev2.model.RecognizeUtteranceResponse
      .builder()
      .optionallyWith(
        inputMode.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.inputMode)
      .optionallyWith(
        contentType.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.contentType)
      .optionallyWith(
        messages.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.messages)
      .optionallyWith(
        interpretations.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.interpretations)
      .optionallyWith(
        sessionState.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.sessionState)
      .optionallyWith(
        requestAttributes.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.requestAttributes)
      .optionallyWith(
        sessionId.map(value => SessionId.unwrap(value): java.lang.String)
      )(_.sessionId)
      .optionallyWith(
        inputTranscript.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.inputTranscript)
      .build()
  }
  def asReadOnly
      : zio.aws.lexruntimev2.model.RecognizeUtteranceResponse.ReadOnly =
    zio.aws.lexruntimev2.model.RecognizeUtteranceResponse.wrap(buildAwsValue())
}
object RecognizeUtteranceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntimev2.model.RecognizeUtteranceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexruntimev2.model.RecognizeUtteranceResponse =
      zio.aws.lexruntimev2.model.RecognizeUtteranceResponse(
        inputMode.map(value => value),
        contentType.map(value => value),
        messages.map(value => value),
        interpretations.map(value => value),
        sessionState.map(value => value),
        requestAttributes.map(value => value),
        sessionId.map(value => value),
        inputTranscript.map(value => value)
      )
    def inputMode: Option[NonEmptyString]
    def contentType: Option[NonEmptyString]
    def messages: Option[NonEmptyString]
    def interpretations: Option[NonEmptyString]
    def sessionState: Option[NonEmptyString]
    def requestAttributes: Option[NonEmptyString]
    def sessionId: Option[SessionId]
    def inputTranscript: Option[NonEmptyString]
    def getInputMode: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("inputMode", inputMode)
    def getContentType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("contentType", contentType)
    def getMessages: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("messages", messages)
    def getInterpretations: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("interpretations", interpretations)
    def getSessionState: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("sessionState", sessionState)
    def getRequestAttributes: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("requestAttributes", requestAttributes)
    def getSessionId: ZIO[Any, AwsError, SessionId] =
      AwsError.unwrapOptionField("sessionId", sessionId)
    def getInputTranscript: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("inputTranscript", inputTranscript)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexruntimev2.model.RecognizeUtteranceResponse
  ) extends zio.aws.lexruntimev2.model.RecognizeUtteranceResponse.ReadOnly {
    override val inputMode: Option[NonEmptyString] = scala
      .Option(impl.inputMode())
      .map(value => zio.aws.lexruntimev2.model.primitives.NonEmptyString(value))
    override val contentType: Option[NonEmptyString] = scala
      .Option(impl.contentType())
      .map(value => zio.aws.lexruntimev2.model.primitives.NonEmptyString(value))
    override val messages: Option[NonEmptyString] = scala
      .Option(impl.messages())
      .map(value => zio.aws.lexruntimev2.model.primitives.NonEmptyString(value))
    override val interpretations: Option[NonEmptyString] = scala
      .Option(impl.interpretations())
      .map(value => zio.aws.lexruntimev2.model.primitives.NonEmptyString(value))
    override val sessionState: Option[NonEmptyString] = scala
      .Option(impl.sessionState())
      .map(value => zio.aws.lexruntimev2.model.primitives.NonEmptyString(value))
    override val requestAttributes: Option[NonEmptyString] = scala
      .Option(impl.requestAttributes())
      .map(value => zio.aws.lexruntimev2.model.primitives.NonEmptyString(value))
    override val sessionId: Option[SessionId] = scala
      .Option(impl.sessionId())
      .map(value => zio.aws.lexruntimev2.model.primitives.SessionId(value))
    override val inputTranscript: Option[NonEmptyString] = scala
      .Option(impl.inputTranscript())
      .map(value => zio.aws.lexruntimev2.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntimev2.model.RecognizeUtteranceResponse
  ): zio.aws.lexruntimev2.model.RecognizeUtteranceResponse.ReadOnly =
    new Wrapper(impl)
}
